/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionResourceDeliveryMessageConsumer;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionConsumerCache {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionConsumerCache.class);
    private final Map<String, SubscriptionResourceDeliveryMessageConsumer> myCache = new ConcurrentHashMap<String, SubscriptionResourceDeliveryMessageConsumer>();

    SubscriptionConsumerCache() {
    }

    public SubscriptionResourceDeliveryMessageConsumer get(String theChannelName) {
        return this.myCache.get(theChannelName);
    }

    public int size() {
        return this.myCache.size();
    }

    public void put(String theChannelName, SubscriptionResourceDeliveryMessageConsumer theValue) {
        this.myCache.put(theChannelName, theValue);
    }

    void closeAndRemove(String theChannelName) {
        Validate.notBlank((CharSequence)theChannelName);
        SubscriptionResourceDeliveryMessageConsumer subscriptionResourceDeliveryMessageConsumer = this.myCache.remove(theChannelName);
        if (subscriptionResourceDeliveryMessageConsumer != null) {
            subscriptionResourceDeliveryMessageConsumer.close();
        }
    }

    public boolean containsKey(String theChannelName) {
        return this.myCache.containsKey(theChannelName);
    }

    @VisibleForTesting
    void logForUnitTest() {
        for (String key : this.myCache.keySet()) {
            ourLog.info("SubscriptionConsumerCache: {}", (Object)key);
        }
    }
}

