/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.jpa.subscription.match.deliver.email.IEmailSender;
import ca.uhn.fhir.jpa.subscription.match.deliver.email.SubscriptionDeliveringEmailListener;
import ca.uhn.fhir.jpa.subscription.match.deliver.message.SubscriptionDeliveringMessageListener;
import ca.uhn.fhir.jpa.subscription.match.deliver.resthook.SubscriptionDeliveringRestHookListener;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import java.util.Optional;
import org.springframework.context.ApplicationContext;

public class SubscriptionDeliveryListenerFactory {
    protected ApplicationContext myApplicationContext;
    private IEmailSender myEmailSender;

    public SubscriptionDeliveryListenerFactory(ApplicationContext theApplicationContext, IEmailSender theEmailSender) {
        this.myApplicationContext = theApplicationContext;
        this.myEmailSender = theEmailSender;
    }

    protected SubscriptionDeliveringEmailListener newSubscriptionDeliveringEmailListener(IEmailSender theEmailSender) {
        return (SubscriptionDeliveringEmailListener)this.myApplicationContext.getBean(SubscriptionDeliveringEmailListener.class, new Object[]{theEmailSender});
    }

    protected SubscriptionDeliveringRestHookListener newSubscriptionDeliveringRestHookListener() {
        return (SubscriptionDeliveringRestHookListener)this.myApplicationContext.getBean(SubscriptionDeliveringRestHookListener.class);
    }

    protected SubscriptionDeliveringMessageListener newSubscriptionDeliveringMessageListener() {
        return (SubscriptionDeliveringMessageListener)this.myApplicationContext.getBean(SubscriptionDeliveringMessageListener.class);
    }

    public Optional<IMessageListener<ResourceDeliveryMessage>> createDeliveryListener(CanonicalSubscriptionChannelType theChannelType) {
        if (theChannelType == CanonicalSubscriptionChannelType.EMAIL) {
            return Optional.of(this.newSubscriptionDeliveringEmailListener(this.myEmailSender));
        }
        if (theChannelType == CanonicalSubscriptionChannelType.RESTHOOK) {
            return Optional.of(this.newSubscriptionDeliveringRestHookListener());
        }
        if (theChannelType == CanonicalSubscriptionChannelType.MESSAGE) {
            return Optional.of(this.newSubscriptionDeliveringMessageListener());
        }
        return Optional.empty();
    }
}

