/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.subscription.api.ISubscriptionDeliveryValidator;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionInactiveException;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionCanonicalizer;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionDeliveryValidator
implements ISubscriptionDeliveryValidator {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionDeliveryValidator.class);
    private final DaoRegistry myDaoRegistry;
    private final SubscriptionCanonicalizer mySubscriptionCanonicalizer;

    public SubscriptionDeliveryValidator(DaoRegistry theDaoRegistry, SubscriptionCanonicalizer theSubscriptionCanonicalizer) {
        this.myDaoRegistry = theDaoRegistry;
        this.mySubscriptionCanonicalizer = theSubscriptionCanonicalizer;
    }

    @Override
    public void validate(IIdType theSubscriptionId, ResourceDeliveryMessage theResourceDeliveryMessage) {
        IBaseResource resource;
        ourLog.debug("Retrieving subscription {}", (Object)theSubscriptionId);
        try {
            SystemRequestDetails systemRequestDetails = new SystemRequestDetails();
            systemRequestDetails.setRequestPartitionId(theResourceDeliveryMessage.getPartitionId());
            resource = this.myDaoRegistry.getSubscriptionDao().read(theSubscriptionId, (RequestDetails)systemRequestDetails);
        }
        catch (ResourceNotFoundException e) {
            throw new SubscriptionInactiveException(Msg.code((int)2667) + "Attempting to deliver " + theResourceDeliveryMessage.getPayloadId() + " to deleted subscription " + String.valueOf(theSubscriptionId) + ".  Aborting delivery.");
        }
        ourLog.debug("Retrieved resource {}", (Object)resource.getIdElement());
        CanonicalSubscription subscription = this.mySubscriptionCanonicalizer.canonicalize(resource);
        switch (subscription.getStatus()) {
            case ACTIVE: 
            case REQUESTED: {
                return;
            }
        }
        throw new SubscriptionInactiveException(Msg.code((int)2668) + "Attempting to deliver " + theResourceDeliveryMessage.getPayloadId() + " to disabled subscription " + subscription.getIdElementString() + ".  Aborting delivery.");
    }
}

