/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.broker.api.IChannelProducer;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.util.IoUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionProducerCache {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionProducerCache.class);
    private final Map<String, IChannelProducer<ResourceDeliveryMessage>> myChannelProducers = new ConcurrentHashMap<String, IChannelProducer<ResourceDeliveryMessage>>();

    public void put(String theChannelName, IChannelProducer<ResourceDeliveryMessage> theProducer) {
        this.myChannelProducers.put(theChannelName, theProducer);
    }

    public void closeAndRemove(String theChannelName) {
        IChannelProducer<ResourceDeliveryMessage> producer = this.myChannelProducers.get(theChannelName);
        if (producer instanceof AutoCloseable) {
            IoUtils.closeQuietly((AutoCloseable)((AutoCloseable)producer), (Logger)ourLog);
        }
        this.myChannelProducers.remove(theChannelName);
    }

    public IChannelProducer<ResourceDeliveryMessage> get(String theChannelName) {
        return this.myChannelProducers.get(theChannelName);
    }
}

