/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.broker.api.IChannelConsumer;
import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.broker.impl.MultiplexingListener;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.util.IoUtils;
import com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionResourceDeliveryMessageConsumer
implements AutoCloseable {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionResourceDeliveryMessageConsumer.class);
    private final IChannelConsumer<ResourceDeliveryMessage> myConsumer;
    private final MultiplexingListener<ResourceDeliveryMessage> myMultiplexingListener;

    public SubscriptionResourceDeliveryMessageConsumer(IChannelConsumer<ResourceDeliveryMessage> theConsumer) {
        this.myConsumer = theConsumer;
        this.myMultiplexingListener = (MultiplexingListener)theConsumer.getMessageListener();
    }

    public boolean addListener(IMessageListener<ResourceDeliveryMessage> theListener) {
        return this.myMultiplexingListener.addListener(theListener);
    }

    public boolean removeListener(IMessageListener<ResourceDeliveryMessage> theListener) {
        if (theListener instanceof AutoCloseable) {
            IoUtils.closeQuietly((AutoCloseable)((AutoCloseable)theListener), (Logger)ourLog);
        }
        return this.myMultiplexingListener.removeListener(theListener);
    }

    @Override
    public void close() {
        IoUtils.closeQuietly(this.myConsumer, (Logger)ourLog);
    }

    public String getChannelName() {
        return this.myConsumer.getChannelName();
    }

    public IChannelConsumer<ResourceDeliveryMessage> getConsumer() {
        return this.myConsumer;
    }

    @VisibleForTesting
    public <L extends IMessageListener<ResourceDeliveryMessage>> L getListenerOfTypeOrNull(Class<L> theMessageListenerClass) {
        return (L)this.myMultiplexingListener.getListenerOfTypeOrNull(theMessageListenerClass);
    }
}

