/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.broker.api.IRetryAwareMessageListener;
import ca.uhn.fhir.jpa.subscription.api.ISubscriptionDeliveryValidator;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import ca.uhn.fhir.rest.server.messaging.IMessageDeliveryContext;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IIdType;

public class SubscriptionValidatingListener
implements IRetryAwareMessageListener<ResourceDeliveryMessage> {
    private final ISubscriptionDeliveryValidator mySubscriptionDeliveryValidator;
    private final IIdType mySubscriptionId;

    public SubscriptionValidatingListener(ISubscriptionDeliveryValidator theSubscriptionDeliveryValidator, IIdType theSubscriptionId) {
        this.mySubscriptionDeliveryValidator = theSubscriptionDeliveryValidator;
        this.mySubscriptionId = theSubscriptionId;
    }

    public void handleMessage(@Nullable IMessageDeliveryContext theMessageDeliveryContext, @Nonnull IMessage<ResourceDeliveryMessage> theMessage) {
        if (theMessageDeliveryContext != null && theMessageDeliveryContext.getRetryCount() > 0 && this.mySubscriptionDeliveryValidator != null) {
            this.mySubscriptionDeliveryValidator.validate(this.mySubscriptionId, (ResourceDeliveryMessage)theMessage.getPayload());
        }
    }

    public Class<ResourceDeliveryMessage> getPayloadType() {
        return ResourceDeliveryMessage.class;
    }
}

