/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver.email;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.email.EmailBuilder;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.thymeleaf.spring6.dialect.SpringStandardDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

public class EmailDetails {
    private final SpringTemplateEngine myTemplateEngine = this.makeTemplateEngine();
    private final Context myContext = new Context();
    private String mySubjectTemplate;
    private String myBodyTemplate;
    private List<String> myTo;
    private String myFrom;
    private IIdType mySubscription;

    public String getBody() {
        return this.myTemplateEngine.process(this.myBodyTemplate, (IContext)this.myContext);
    }

    public void setBodyTemplate(String theBodyTemplate) {
        this.myBodyTemplate = theBodyTemplate;
    }

    public String getFrom() {
        return StringUtils.trim((String)this.myFrom);
    }

    public void setFrom(String theFrom) {
        this.myFrom = theFrom;
    }

    public String getSubject() {
        return this.myTemplateEngine.process(this.mySubjectTemplate, (IContext)this.myContext);
    }

    public void setSubjectTemplate(String theSubjectTemplate) {
        this.mySubjectTemplate = theSubjectTemplate;
    }

    public String getSubscriptionId() {
        return this.mySubscription.toUnqualifiedVersionless().getValue();
    }

    public void setSubscription(IIdType theSubscription) {
        this.mySubscription = theSubscription;
    }

    public String getTo() {
        return this.myTo.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
    }

    public void setTo(List<String> theTo) {
        this.myTo = theTo;
    }

    public Email toEmail() {
        try {
            return EmailBuilder.startingBlank().from(this.getFrom()).to(this.getTo()).withSubject(this.getSubject()).withPlainText(this.getBody()).withHeader("X-FHIR-Subscription", (Object)this.getSubscriptionId()).buildEmail();
        }
        catch (IllegalArgumentException e) {
            throw new InternalErrorException(Msg.code((int)3) + "Failed to create email message", (Throwable)e);
        }
    }

    @Nonnull
    private SpringTemplateEngine makeTemplateEngine() {
        StringTemplateResolver stringTemplateResolver = new StringTemplateResolver();
        stringTemplateResolver.setTemplateMode(TemplateMode.TEXT);
        SpringStandardDialect springStandardDialect = new SpringStandardDialect();
        springStandardDialect.setEnableSpringELCompiler(true);
        SpringTemplateEngine springTemplateEngine = new SpringTemplateEngine();
        springTemplateEngine.setDialect((IDialect)springStandardDialect);
        springTemplateEngine.setEnableSpringELCompiler(true);
        springTemplateEngine.setTemplateResolver((ITemplateResolver)stringTemplateResolver);
        return springTemplateEngine;
    }
}

