/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver.email;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.model.config.SubscriptionSettings;
import ca.uhn.fhir.jpa.subscription.match.deliver.BaseSubscriptionDeliveryListener;
import ca.uhn.fhir.jpa.subscription.match.deliver.email.EmailDetails;
import ca.uhn.fhir.jpa.subscription.match.deliver.email.IEmailSender;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.api.EncodingEnum;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionDeliveringEmailListener
extends BaseSubscriptionDeliveryListener {
    private Logger ourLog = LoggerFactory.getLogger(SubscriptionDeliveringEmailListener.class);
    @Autowired
    private SubscriptionSettings mySubscriptionSettings;
    @Autowired
    private FhirContext myCtx;
    private IEmailSender myEmailSender;

    @Autowired
    public SubscriptionDeliveringEmailListener(IEmailSender theEmailSender) {
        this.myEmailSender = theEmailSender;
    }

    public Class<ResourceDeliveryMessage> getPayloadType() {
        return ResourceDeliveryMessage.class;
    }

    @Override
    public void handleMessage(ResourceDeliveryMessage theMessage) throws Exception {
        EncodingEnum encoding;
        String[] destinationAddressStrings;
        CanonicalSubscription subscription = theMessage.getSubscription();
        String endpointUrl = subscription.getEndpointUrl();
        ArrayList<String> destinationAddresses = new ArrayList<String>();
        for (String next : destinationAddressStrings = StringUtils.split((String)endpointUrl, (String)",")) {
            if (!StringUtils.isNotBlank((CharSequence)(next = this.processEmailAddressUri(next)))) continue;
            destinationAddresses.add(next);
        }
        String payload = "";
        if (StringUtils.isNotBlank((CharSequence)subscription.getPayloadString()) && (encoding = EncodingEnum.forContentType((String)subscription.getPayloadString())) != null) {
            payload = this.getPayloadStringFromMessageOrEmptyString(theMessage);
        }
        String from = this.processEmailAddressUri(StringUtils.defaultString((String)subscription.getEmailDetails().getFrom(), (String)this.mySubscriptionSettings.getEmailFromAddress()));
        String subjectTemplate = StringUtils.defaultString((String)subscription.getEmailDetails().getSubjectTemplate(), (String)this.provideDefaultSubjectTemplate());
        EmailDetails details = new EmailDetails();
        details.setTo(destinationAddresses);
        details.setFrom(from);
        details.setBodyTemplate(payload);
        details.setSubjectTemplate(subjectTemplate);
        details.setSubscription(subscription.getIdElement(this.myFhirContext));
        this.myEmailSender.send(details);
    }

    private String processEmailAddressUri(String next) {
        if ((next = StringUtils.trim((String)StringUtils.defaultString((String)next))).startsWith("mailto:")) {
            next = next.substring("mailto:".length());
        }
        return next;
    }

    private String provideDefaultSubjectTemplate() {
        return "HAPI FHIR Subscriptions";
    }

    public void setEmailSender(IEmailSender theEmailSender) {
        this.myEmailSender = theEmailSender;
    }

    @VisibleForTesting
    public IEmailSender getEmailSender() {
        return this.myEmailSender;
    }

    private String getPayloadStringFromMessageOrEmptyString(ResourceDeliveryMessage theMessage) {
        String payload = theMessage.getPayloadString();
        if (theMessage.getPayload(this.myCtx) != null) {
            return payload;
        }
        Optional<ResourceModifiedMessage> inflatedMessage = this.inflateResourceModifiedMessageFromDeliveryMessage(theMessage);
        if (inflatedMessage.isEmpty()) {
            return "";
        }
        payload = inflatedMessage.get().getPayloadString();
        return payload;
    }
}

