/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver.message;

import ca.uhn.fhir.broker.api.ChannelProducerSettings;
import ca.uhn.fhir.broker.api.IBrokerClient;
import ca.uhn.fhir.broker.api.IChannelProducer;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.IDefaultPartitionSettings;
import ca.uhn.fhir.jpa.subscription.match.deliver.BaseSubscriptionDeliveryListener;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import ca.uhn.fhir.util.IoUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.messaging.MessagingException;

@Scope(value="prototype")
public class SubscriptionDeliveringMessageListener
extends BaseSubscriptionDeliveryListener
implements AutoCloseable {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionDeliveringMessageListener.class);
    private final IBrokerClient myBrokerClient;
    private IChannelProducer<ResourceModifiedMessage> myChannelProducer;
    private final IDefaultPartitionSettings myDefaultPartitionSettings;

    public SubscriptionDeliveringMessageListener(IBrokerClient theBrokerClient, IDefaultPartitionSettings theDefaultPartitionSettings) {
        this.myBrokerClient = theBrokerClient;
        this.myDefaultPartitionSettings = theDefaultPartitionSettings;
    }

    public Class<ResourceDeliveryMessage> getPayloadType() {
        return ResourceDeliveryMessage.class;
    }

    protected void doDelivery(ResourceDeliveryMessage theSourceMessage, CanonicalSubscription theSubscription, IChannelProducer<ResourceModifiedMessage> theChannelProducer, ResourceModifiedJsonMessage theWrappedMessageToSend) {
        String payloadId = theSourceMessage.getPayloadId();
        if (StringUtils.isNotBlank((CharSequence)theSubscription.getPayloadSearchCriteria())) {
            IBaseBundle payloadResource = this.createDeliveryBundleForPayloadSearchCriteria(theSubscription, theWrappedMessageToSend.getPayload().getResource(this.myFhirContext));
            ResourceModifiedJsonMessage newWrappedMessageToSend = this.convertDeliveryMessageToResourceModifiedJsonMessage(theSourceMessage, (IBaseResource)payloadResource);
            theWrappedMessageToSend.setPayload(newWrappedMessageToSend.getPayload());
            payloadId = payloadResource.getIdElement().toUnqualifiedVersionless().getValue();
        }
        theChannelProducer.send((IMessage)theWrappedMessageToSend);
        ourLog.debug("Delivering {} message payload {} for {}", new Object[]{theSourceMessage.getOperationType(), payloadId, theSubscription.getIdElement(this.myFhirContext).toUnqualifiedVersionless().getValue()});
    }

    private ResourceModifiedJsonMessage convertDeliveryMessageToResourceModifiedJsonMessage(ResourceDeliveryMessage theMsg, IBaseResource thePayloadResource) {
        ResourceModifiedMessage payload = new ResourceModifiedMessage(this.myFhirContext, thePayloadResource, theMsg.getOperationType(), this.myDefaultPartitionSettings.getDefaultRequestPartitionId());
        payload.setPayloadMessageKey(theMsg.getPayloadMessageKey());
        payload.setTransactionId(theMsg.getTransactionId());
        payload.setPartitionId(theMsg.getPartitionId());
        return new ResourceModifiedJsonMessage(payload);
    }

    @Override
    public void handleMessage(ResourceDeliveryMessage theMessage) throws MessagingException, URISyntaxException {
        CanonicalSubscription subscription = theMessage.getSubscription();
        IBaseResource payloadResource = theMessage.getPayload(this.myFhirContext);
        if (payloadResource == null) {
            Optional<ResourceModifiedMessage> inflatedMsg = this.inflateResourceModifiedMessageFromDeliveryMessage(theMessage);
            if (inflatedMsg.isEmpty()) {
                return;
            }
            payloadResource = inflatedMsg.get().getResource(this.myFhirContext);
        }
        ResourceModifiedJsonMessage messageWrapperToSend = this.convertDeliveryMessageToResourceModifiedJsonMessage(theMessage, payloadResource);
        HookParams params = new HookParams().add(CanonicalSubscription.class, (Object)subscription).add(ResourceDeliveryMessage.class, (Object)theMessage).add(ResourceModifiedJsonMessage.class, (Object)messageWrapperToSend);
        if (!this.getInterceptorBroadcaster().callHooks((IPointcut)Pointcut.SUBSCRIPTION_BEFORE_MESSAGE_DELIVERY, params)) {
            return;
        }
        String endpointUrl = subscription.getEndpointUrl();
        String queueName = this.extractQueueNameFromEndpoint(endpointUrl);
        ChannelProducerSettings channelSettings = new ChannelProducerSettings();
        channelSettings.setQualifyChannelName(false);
        if (this.myChannelProducer == null) {
            this.myChannelProducer = this.myBrokerClient.getOrCreateProducer(queueName, ResourceModifiedJsonMessage.class, channelSettings);
        }
        String payloadString = subscription.getPayloadString();
        EncodingEnum payloadType = null;
        if (payloadString != null) {
            payloadType = EncodingEnum.forContentType((String)payloadString);
        }
        if (payloadType != EncodingEnum.JSON) {
            throw new UnsupportedOperationException(Msg.code((int)4) + "Only JSON payload type is currently supported for Message Subscriptions");
        }
        this.doDelivery(theMessage, subscription, this.myChannelProducer, messageWrapperToSend);
        params = new HookParams().add(CanonicalSubscription.class, (Object)subscription).add(ResourceDeliveryMessage.class, (Object)theMessage);
        if (!this.getInterceptorBroadcaster().callHooks((IPointcut)Pointcut.SUBSCRIPTION_AFTER_MESSAGE_DELIVERY, params)) {
            return;
        }
    }

    private String extractQueueNameFromEndpoint(String theEndpointUrl) throws URISyntaxException {
        URI uri = new URI(theEndpointUrl);
        return uri.getSchemeSpecificPart();
    }

    @Override
    public void close() throws Exception {
        if (this.myChannelProducer instanceof AutoCloseable) {
            IoUtils.closeQuietly((AutoCloseable)((AutoCloseable)this.myChannelProducer), (Logger)ourLog);
        }
    }
}

