/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.matching;

import ca.uhn.fhir.jpa.model.config.SubscriptionSettings;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.DaoSubscriptionMatcher;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.ISubscriptionMatcher;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.InMemorySubscriptionMatcher;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CompositeInMemoryDaoSubscriptionMatcher
implements ISubscriptionMatcher {
    private Logger ourLog = LoggerFactory.getLogger(CompositeInMemoryDaoSubscriptionMatcher.class);
    private final DaoSubscriptionMatcher myDaoSubscriptionMatcher;
    private final InMemorySubscriptionMatcher myInMemorySubscriptionMatcher;
    @Autowired
    SubscriptionSettings mySubscriptionSettings;

    public CompositeInMemoryDaoSubscriptionMatcher(DaoSubscriptionMatcher theDaoSubscriptionMatcher, InMemorySubscriptionMatcher theInMemorySubscriptionMatcher) {
        this.myDaoSubscriptionMatcher = theDaoSubscriptionMatcher;
        this.myInMemorySubscriptionMatcher = theInMemorySubscriptionMatcher;
    }

    @Override
    public InMemoryMatchResult match(CanonicalSubscription theSubscription, ResourceModifiedMessage theMsg) {
        InMemoryMatchResult result;
        if (this.mySubscriptionSettings.isEnableInMemorySubscriptionMatching()) {
            result = this.myInMemorySubscriptionMatcher.match(theSubscription, theMsg);
            if (result.supported()) {
                result.setInMemory(true);
            } else {
                this.ourLog.info("Criteria {} for Subscription {} not supported by InMemoryMatcher: {}.  Reverting to DatabaseMatcher", new Object[]{theSubscription.getCriteriaString(), theSubscription.getIdElementString(), result.getUnsupportedReason()});
                result = this.myDaoSubscriptionMatcher.match(theSubscription, theMsg);
            }
        } else {
            result = this.myDaoSubscriptionMatcher.match(theSubscription, theMsg);
        }
        return result;
    }
}

