/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.broker.api.ChannelConsumerSettings;
import ca.uhn.fhir.broker.api.IChannelConsumer;
import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.broker.impl.MultiplexingListener;
import ca.uhn.fhir.jpa.model.config.SubscriptionSettings;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelFactory;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionActivatingListener;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionMatchingListener;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionRegisteringListener;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicMatchingListener;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicRegisteringListener;
import ca.uhn.fhir.util.IoUtils;
import jakarta.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

public class MatchingQueueSubscriberLoader {
    private static final Logger ourLog = LoggerFactory.getLogger(MatchingQueueSubscriberLoader.class);
    @Autowired
    private SubscriptionMatchingListener mySubscriptionMatchingListener;
    @Autowired
    private SubscriptionActivatingListener mySubscriptionActivatingListener;
    @Autowired(required=false)
    private SubscriptionTopicMatchingListener mySubscriptionTopicMatchingListener;
    @Autowired
    private SubscriptionRegisteringListener mySubscriptionRegisteringListener;
    @Autowired
    private SubscriptionChannelFactory mySubscriptionChannelFactory;
    @Autowired(required=false)
    private SubscriptionTopicRegisteringListener mySubscriptionTopicRegisteringListener;
    @Autowired
    private SubscriptionSettings mySubscriptionSettings;
    protected IChannelConsumer<ResourceModifiedMessage> myMatchingConsumer;
    private MultiplexingListener<ResourceModifiedMessage> myMultiplexingListener;

    @EventListener(value={ContextRefreshedEvent.class})
    @Order(value=300)
    public void subscribeToMatchingChannel() {
        if (this.myMatchingConsumer == null) {
            this.myMultiplexingListener = new MultiplexingListener(ResourceModifiedMessage.class);
            this.myMatchingConsumer = this.mySubscriptionChannelFactory.newMatchingConsumer("subscription-matching", this.myMultiplexingListener, this.getChannelConsumerSettings());
            this.myMultiplexingListener.addListener((IMessageListener)this.mySubscriptionMatchingListener);
            this.myMultiplexingListener.addListener((IMessageListener)this.mySubscriptionActivatingListener);
            this.myMultiplexingListener.addListener((IMessageListener)this.mySubscriptionRegisteringListener);
            if (this.mySubscriptionTopicMatchingListener != null) {
                ourLog.info("Starting SubscriptionTopic Matching Subscriber");
                this.myMultiplexingListener.addListener((IMessageListener)this.mySubscriptionTopicMatchingListener);
            }
            if (this.mySubscriptionTopicRegisteringListener != null) {
                this.myMultiplexingListener.addListener((IMessageListener)this.mySubscriptionTopicRegisteringListener);
            }
            if (this.myMatchingConsumer != null) {
                ourLog.info("Subscription Matching Subscriber subscribed to Matching Channel {} with name {}", (Object)this.myMatchingConsumer.getClass().getName(), (Object)"subscription-matching");
            }
        }
    }

    private ChannelConsumerSettings getChannelConsumerSettings() {
        ChannelConsumerSettings channelConsumerSettings = new ChannelConsumerSettings();
        channelConsumerSettings.setQualifyChannelName(this.mySubscriptionSettings.isQualifySubscriptionMatchingChannelName());
        return channelConsumerSettings;
    }

    @PreDestroy
    public void stop() throws Exception {
        if (this.myMatchingConsumer != null) {
            ourLog.info("Destroying matching Channel {} with name {}", (Object)this.myMatchingConsumer.getClass().getName(), (Object)"subscription-matching");
            IoUtils.closeQuietly(this.myMatchingConsumer, (Logger)ourLog);
        }
        if (this.myMultiplexingListener != null) {
            IoUtils.closeQuietly(this.myMultiplexingListener, (Logger)ourLog);
        }
    }
}

