/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.model.config.SubscriptionSettings;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionCanonicalizer;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import ca.uhn.fhir.subscription.api.IResourceModifiedMessagePersistenceSvc;
import ca.uhn.fhir.util.SubscriptionUtil;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.hl7.fhir.dstu2.model.Subscription;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionActivatingListener
implements IMessageListener<ResourceModifiedMessage> {
    private final Logger ourLog = LoggerFactory.getLogger(SubscriptionActivatingListener.class);
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private SubscriptionCanonicalizer mySubscriptionCanonicalizer;
    @Autowired
    private SubscriptionSettings mySubscriptionSettings;
    @Autowired
    private IResourceModifiedMessagePersistenceSvc myResourceModifiedMessagePersistenceSvc;

    public Class<ResourceModifiedMessage> getPayloadType() {
        return ResourceModifiedMessage.class;
    }

    public void handleMessage(@Nonnull IMessage<ResourceModifiedMessage> theMessage) {
        ResourceModifiedMessage payload = (ResourceModifiedMessage)theMessage.getPayload();
        if (!payload.hasResourceType(this.myFhirContext, "Subscription")) {
            return;
        }
        switch (payload.getOperationType()) {
            case CREATE: 
            case UPDATE: {
                if (payload.getResource(this.myFhirContext) == null) {
                    Optional inflatedMsg = this.myResourceModifiedMessagePersistenceSvc.inflatePersistedResourceModifiedMessageOrNull(payload);
                    if (inflatedMsg.isEmpty()) {
                        return;
                    }
                    payload = (ResourceModifiedMessage)inflatedMsg.get();
                }
                this.activateSubscriptionIfRequired(payload.getNewResource(this.myFhirContext));
                break;
            }
        }
    }

    public synchronized boolean activateSubscriptionIfRequired(IBaseResource theSubscription) {
        CanonicalSubscriptionChannelType subscriptionChannelType = this.mySubscriptionCanonicalizer.getChannelType(theSubscription);
        if (subscriptionChannelType == null || !this.mySubscriptionSettings.getSupportedSubscriptionTypes().contains(subscriptionChannelType.toCanonical())) {
            return false;
        }
        String statusString = this.mySubscriptionCanonicalizer.getSubscriptionStatus(theSubscription);
        if ("requested".equals(statusString)) {
            return this.activateSubscription(theSubscription);
        }
        return false;
    }

    private boolean activateSubscription(IBaseResource theSubscription) {
        IFhirResourceDao subscriptionDao = this.myDaoRegistry.getSubscriptionDao();
        SystemRequestDetails srd = SystemRequestDetails.forAllPartitions();
        IBaseResource subscription = null;
        try {
            subscription = subscriptionDao.read(theSubscription.getIdElement(), (RequestDetails)SystemRequestDetails.forAllPartitions());
            subscription.setId(subscription.getIdElement().toVersionless());
            this.ourLog.info("Activating subscription {} from status {} to {}", new Object[]{subscription.getIdElement().toUnqualified().getValue(), "requested", "active"});
            SubscriptionUtil.setStatus((FhirContext)this.myFhirContext, (IBaseResource)subscription, (String)"active");
            RequestPartitionId partitionId = (RequestPartitionId)subscription.getUserData(Constants.RESOURCE_PARTITION_ID);
            subscriptionDao.update(subscription, (RequestDetails)new SystemRequestDetails().setRequestPartitionId(partitionId));
            return true;
        }
        catch (ResourceGoneException | UnprocessableEntityException e) {
            subscription = subscription != null ? subscription : theSubscription;
            this.ourLog.error("Failed to activate subscription " + String.valueOf(subscription.getIdElement()) + " : " + e.getMessage());
            this.ourLog.info("Changing status of {} to ERROR", (Object)subscription.getIdElement());
            SubscriptionUtil.setStatus((FhirContext)this.myFhirContext, (IBaseResource)subscription, (String)"error");
            SubscriptionUtil.setReason((FhirContext)this.myFhirContext, (IBaseResource)subscription, (String)e.getMessage());
            subscriptionDao.update(subscription, (RequestDetails)srd);
            return false;
        }
    }

    public boolean isChannelTypeSupported(IBaseResource theSubscription) {
        Subscription.SubscriptionChannelType channelType = this.mySubscriptionCanonicalizer.getChannelType(theSubscription).toCanonical();
        return this.mySubscriptionSettings.getSupportedSubscriptionTypes().contains(channelType);
    }
}

