/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicDispatchRequest;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import jakarta.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class SubscriptionDeliveryRequest {
    private final IBaseResource myPayload;
    private final IIdType myPayloadId;
    private final ActiveSubscription myActiveSubscription;
    private final RestOperationTypeEnum myRestOperationType;
    private final RequestPartitionId myRequestPartitionId;
    private final String myTransactionId;

    public SubscriptionDeliveryRequest(IBaseBundle theBundlePayload, ActiveSubscription theActiveSubscription, SubscriptionTopicDispatchRequest theSubscriptionTopicDispatchRequest) {
        this.myPayload = theBundlePayload;
        this.myPayloadId = null;
        this.myActiveSubscription = theActiveSubscription;
        this.myRestOperationType = theSubscriptionTopicDispatchRequest.getRequestType();
        this.myRequestPartitionId = theSubscriptionTopicDispatchRequest.getRequestPartitionId();
        this.myTransactionId = theSubscriptionTopicDispatchRequest.getTransactionId();
    }

    public SubscriptionDeliveryRequest(@Nonnull IBaseResource thePayload, @Nonnull ResourceModifiedMessage theMsg, @Nonnull ActiveSubscription theActiveSubscription) {
        this.myPayload = thePayload;
        this.myPayloadId = null;
        this.myActiveSubscription = theActiveSubscription;
        this.myRestOperationType = theMsg.getOperationType().asRestOperationType();
        this.myRequestPartitionId = theMsg.getPartitionId();
        this.myTransactionId = theMsg.getTransactionId();
    }

    public SubscriptionDeliveryRequest(@Nonnull IIdType thePayloadId, @Nonnull ResourceModifiedMessage theMsg, @Nonnull ActiveSubscription theActiveSubscription) {
        this.myPayload = null;
        this.myPayloadId = thePayloadId;
        this.myActiveSubscription = theActiveSubscription;
        this.myRestOperationType = theMsg.getOperationType().asRestOperationType();
        this.myRequestPartitionId = theMsg.getPartitionId();
        this.myTransactionId = theMsg.getTransactionId();
    }

    public IBaseResource getPayload() {
        return this.myPayload;
    }

    public ActiveSubscription getActiveSubscription() {
        return this.myActiveSubscription;
    }

    public RestOperationTypeEnum getRestOperationType() {
        return this.myRestOperationType;
    }

    public BaseResourceMessage.OperationTypeEnum getOperationType() {
        return BaseResourceMessage.OperationTypeEnum.from((RestOperationTypeEnum)this.myRestOperationType);
    }

    public RequestPartitionId getRequestPartitionId() {
        return this.myRequestPartitionId;
    }

    public String getTransactionId() {
        return this.myTransactionId;
    }

    public CanonicalSubscription getSubscription() {
        return this.myActiveSubscription.getSubscription();
    }

    public IIdType getPayloadId() {
        return this.myPayloadId;
    }

    public boolean hasPayload() {
        return this.myPayload != null;
    }
}

