/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.broker.api.IChannelProducer;
import ca.uhn.fhir.broker.api.ISendResult;
import ca.uhn.fhir.broker.api.PayloadTooLargeException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelRegistry;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionDeliveryRequest;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionMatchDeliverer {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionMatchDeliverer.class);
    private final FhirContext myFhirContext;
    private final IInterceptorBroadcaster myInterceptorBroadcaster;
    private final SubscriptionChannelRegistry mySubscriptionChannelRegistry;

    public SubscriptionMatchDeliverer(FhirContext theFhirContext, IInterceptorBroadcaster theInterceptorBroadcaster, SubscriptionChannelRegistry theSubscriptionChannelRegistry) {
        this.myFhirContext = theFhirContext;
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
        this.mySubscriptionChannelRegistry = theSubscriptionChannelRegistry;
    }

    public ISendResult deliverPayload(@Nullable IBaseResource thePayload, @Nonnull ResourceModifiedMessage theMsg, @Nonnull ActiveSubscription theActiveSubscription, @Nullable InMemoryMatchResult theInMemoryMatchResult) {
        SubscriptionDeliveryRequest subscriptionDeliveryRequest = thePayload != null ? new SubscriptionDeliveryRequest(thePayload, theMsg, theActiveSubscription) : new SubscriptionDeliveryRequest(theMsg.getPayloadId(this.myFhirContext), theMsg, theActiveSubscription);
        ResourceDeliveryMessage deliveryMsg = this.buildResourceDeliveryMessage(subscriptionDeliveryRequest);
        deliveryMsg.copyAdditionalPropertiesFrom((BaseResourceMessage)theMsg);
        return this.sendToDeliveryChannel(theActiveSubscription, theInMemoryMatchResult, deliveryMsg);
    }

    public ISendResult deliverPayload(@Nonnull SubscriptionDeliveryRequest subscriptionDeliveryRequest, @Nullable InMemoryMatchResult theInMemoryMatchResult) {
        ResourceDeliveryMessage deliveryMsg = this.buildResourceDeliveryMessage(subscriptionDeliveryRequest);
        return this.sendToDeliveryChannel(subscriptionDeliveryRequest.getActiveSubscription(), theInMemoryMatchResult, deliveryMsg);
    }

    private ISendResult sendToDeliveryChannel(@Nonnull ActiveSubscription theActiveSubscription, @Nullable InMemoryMatchResult theInMemoryMatchResult, @Nonnull ResourceDeliveryMessage deliveryMsg) {
        if (!this.callHooks(theActiveSubscription, theInMemoryMatchResult, deliveryMsg)) {
            return ISendResult.FAILURE;
        }
        ResourceDeliveryJsonMessage wrappedMsg = new ResourceDeliveryJsonMessage(deliveryMsg);
        IChannelProducer<ResourceDeliveryMessage> deliveryProducer = this.mySubscriptionChannelRegistry.getDeliveryChannelProducer(theActiveSubscription.getChannelName());
        if (deliveryProducer != null) {
            return this.trySendToDeliveryChannel(wrappedMsg, deliveryProducer);
        }
        ourLog.warn("Do not have delivery channel for subscription {}", (Object)theActiveSubscription.getId());
        return ISendResult.FAILURE;
    }

    private ResourceDeliveryMessage buildResourceDeliveryMessage(@Nonnull SubscriptionDeliveryRequest theRequest) {
        EncodingEnum encoding = null;
        CanonicalSubscription subscription = theRequest.getSubscription();
        if (subscription != null && subscription.getPayloadString() != null && !subscription.getPayloadString().isEmpty()) {
            encoding = EncodingEnum.forContentType((String)subscription.getPayloadString());
        }
        encoding = (EncodingEnum)ObjectUtils.defaultIfNull(encoding, (Object)EncodingEnum.JSON);
        ResourceDeliveryMessage deliveryMsg = new ResourceDeliveryMessage();
        deliveryMsg.setPartitionId(theRequest.getRequestPartitionId());
        if (theRequest.hasPayload()) {
            deliveryMsg.setPayload(this.myFhirContext, theRequest.getPayload(), encoding);
        } else {
            deliveryMsg.setPayloadId(theRequest.getPayloadId());
        }
        deliveryMsg.setSubscription(subscription);
        deliveryMsg.setOperationType(theRequest.getOperationType());
        deliveryMsg.setTransactionId(theRequest.getTransactionId());
        return deliveryMsg;
    }

    private boolean callHooks(ActiveSubscription theActiveSubscription, InMemoryMatchResult theInMemoryMatchResult, ResourceDeliveryMessage deliveryMsg) {
        HookParams params = new HookParams().add(CanonicalSubscription.class, (Object)theActiveSubscription.getSubscription()).add(ResourceDeliveryMessage.class, (Object)deliveryMsg).add(InMemoryMatchResult.class, (Object)theInMemoryMatchResult);
        if (!this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_RESOURCE_MATCHED, params)) {
            ourLog.info("Interceptor has decided to abort processing of subscription {}", (Object)theActiveSubscription.getId());
            return false;
        }
        return true;
    }

    private ISendResult trySendToDeliveryChannel(ResourceDeliveryJsonMessage theWrappedMsg, IChannelProducer<ResourceDeliveryMessage> theDeliveryProducer) {
        try {
            ISendResult retval = theDeliveryProducer.send((IMessage)theWrappedMsg);
            if (!retval.isSuccessful()) {
                ourLog.warn("Failed to send message to Delivery Channel.");
            }
            return retval;
        }
        catch (RuntimeException e) {
            if (e instanceof PayloadTooLargeException || e.getCause() instanceof PayloadTooLargeException) {
                ourLog.warn("Failed to send message to Delivery Channel because the payload size is larger than broker max message size. Retry is about to be performed without payload.");
                ResourceDeliveryJsonMessage msgPayloadLess = this.nullOutPayload(theWrappedMsg);
                return this.trySendToDeliveryChannel(msgPayloadLess, theDeliveryProducer);
            }
            ourLog.error("Failed to send message to Delivery Channel", (Throwable)e);
            throw new RuntimeException(Msg.code((int)7) + "Failed to send message to Delivery Channel", e);
        }
    }

    private ResourceDeliveryJsonMessage nullOutPayload(ResourceDeliveryJsonMessage theWrappedMsg) {
        ResourceDeliveryMessage resourceDeliveryMessage = theWrappedMsg.getPayload();
        resourceDeliveryMessage.setPayloadToNull();
        return new ResourceDeliveryJsonMessage(resourceDeliveryMessage);
    }
}

