/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.broker.api.ISendResult;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.ISubscriptionMatcher;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionCriteriaParser;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionMatchDeliverer;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import ca.uhn.fhir.subscription.api.IResourceModifiedMessagePersistenceSvc;
import ca.uhn.fhir.util.Logs;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionMatchingListener
implements IMessageListener<ResourceModifiedMessage> {
    private static final Logger ourLog = Logs.getSubscriptionTroubleshootingLog();
    public static final String SUBSCRIPTION_MATCHING_CHANNEL_NAME = "subscription-matching";
    @Autowired
    private ISubscriptionMatcher mySubscriptionMatcher;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private SubscriptionRegistry mySubscriptionRegistry;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private SubscriptionMatchDeliverer mySubscriptionMatchDeliverer;
    @Autowired
    private IResourceModifiedMessagePersistenceSvc myResourceModifiedMessagePersistenceSvc;

    public Class<ResourceModifiedMessage> getPayloadType() {
        return ResourceModifiedMessage.class;
    }

    public void handleMessage(@Nonnull IMessage<ResourceModifiedMessage> theMessage) {
        ourLog.trace("Handling resource modified message: {}", theMessage);
        ResourceModifiedMessage msg = (ResourceModifiedMessage)theMessage.getPayload();
        this.matchActiveSubscriptionsAndDeliver(msg);
    }

    public void matchActiveSubscriptionsAndDeliver(ResourceModifiedMessage theMsg) {
        HookParams params;
        switch (theMsg.getOperationType()) {
            case CREATE: 
            case UPDATE: 
            case MANUALLY_TRIGGERED: 
            case DELETE: {
                break;
            }
            default: {
                ourLog.trace("Not processing modified message for {}", (Object)theMsg.getOperationType());
                return;
            }
        }
        if (theMsg.getResource(this.myFhirContext) == null) {
            Optional inflatedMsg = this.myResourceModifiedMessagePersistenceSvc.inflatePersistedResourceModifiedMessageOrNull(theMsg);
            if (inflatedMsg.isEmpty()) {
                return;
            }
            theMsg = (ResourceModifiedMessage)inflatedMsg.get();
        }
        if (!this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_BEFORE_PERSISTED_RESOURCE_CHECKED, params = new HookParams().add(ResourceModifiedMessage.class, (Object)theMsg))) {
            return;
        }
        try {
            this.doMatchActiveSubscriptionsAndDeliver(theMsg);
        }
        finally {
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_AFTER_PERSISTED_RESOURCE_CHECKED, params);
        }
    }

    private void doMatchActiveSubscriptionsAndDeliver(ResourceModifiedMessage theMsg) {
        IIdType resourceId = theMsg.getPayloadId(this.myFhirContext);
        List<ActiveSubscription> subscriptions = this.mySubscriptionRegistry.getAllNonTopicSubscriptions();
        ourLog.trace("Testing {} subscriptions for applicability", (Object)subscriptions.size());
        boolean anySubscriptionsMatchedResource = false;
        for (ActiveSubscription nextActiveSubscription : subscriptions) {
            anySubscriptionsMatchedResource |= this.processSubscription(theMsg, resourceId, nextActiveSubscription).isSuccessful();
        }
        if (!anySubscriptionsMatchedResource) {
            HookParams params = new HookParams().add(ResourceModifiedMessage.class, (Object)theMsg);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_RESOURCE_DID_NOT_MATCH_ANY_SUBSCRIPTIONS, params);
        }
    }

    private ISendResult processSubscription(ResourceModifiedMessage theMsg, IIdType theResourceId, ActiveSubscription theActiveSubscription) {
        InMemoryMatchResult matchResult;
        CanonicalSubscription subscription = theActiveSubscription.getSubscription();
        if (subscription != null && theMsg.getPartitionId() != null && theMsg.getPartitionId().hasPartitionIds() && !subscription.isCrossPartitionEnabled() && !theMsg.getPartitionId().hasPartitionId(subscription.getRequestPartitionId())) {
            return ISendResult.FAILURE;
        }
        String nextSubscriptionId = theActiveSubscription.getId();
        if (StringUtils.isNotBlank((CharSequence)theMsg.getSubscriptionId()) && !theMsg.getSubscriptionId().equals(nextSubscriptionId)) {
            ourLog.debug("Ignoring subscription {} because it is not {}", (Object)nextSubscriptionId, (Object)theMsg.getSubscriptionId());
            return ISendResult.FAILURE;
        }
        if (!this.resourceTypeIsAppropriateForSubscription(theActiveSubscription, theResourceId)) {
            return ISendResult.FAILURE;
        }
        if (theMsg.getOperationType().equals((Object)BaseResourceMessage.OperationTypeEnum.DELETE) && !theActiveSubscription.getSubscription().getSendDeleteMessages()) {
            ourLog.trace("Not processing modified message for {}", (Object)theMsg.getOperationType());
            return ISendResult.FAILURE;
        }
        if (theActiveSubscription.getCriteria().getType() == SubscriptionCriteriaParser.TypeEnum.SEARCH_EXPRESSION) {
            matchResult = this.mySubscriptionMatcher.match(theActiveSubscription.getSubscription(), theMsg);
            if (!matchResult.matched()) {
                ourLog.trace("Subscription {} was not matched by resource {} {}", new Object[]{theActiveSubscription.getId(), theResourceId.toUnqualifiedVersionless().getValue(), matchResult.isInMemory() ? "in-memory" : "by querying the repository"});
                return ISendResult.FAILURE;
            }
            ourLog.debug("Subscription {} was matched by resource {} {}", new Object[]{theActiveSubscription.getId(), theResourceId.toUnqualifiedVersionless().getValue(), matchResult.isInMemory() ? "in-memory" : "by querying the repository"});
        } else {
            ourLog.trace("Subscription {} was not matched by resource {} - No search expression", (Object)theActiveSubscription.getId(), (Object)theResourceId.toUnqualifiedVersionless().getValue());
            matchResult = InMemoryMatchResult.successfulMatch();
            matchResult.setInMemory(true);
        }
        IBaseResource payload = theMsg.getNewResource(this.myFhirContext);
        return this.mySubscriptionMatchDeliverer.deliverPayload(payload, theMsg, theActiveSubscription, matchResult);
    }

    private boolean resourceTypeIsAppropriateForSubscription(ActiveSubscription theActiveSubscription, IIdType theResourceId) {
        SubscriptionCriteriaParser.SubscriptionCriteria criteria = theActiveSubscription.getCriteria();
        String subscriptionId = theActiveSubscription.getId();
        String resourceType = theResourceId.getResourceType();
        ourLog.trace("Checking subscription {} for {} with criteria {}", new Object[]{subscriptionId, resourceType, criteria});
        if (criteria == null) {
            ourLog.trace("Subscription {} has no criteria - Not matching", (Object)subscriptionId);
            return false;
        }
        switch (criteria.getType()) {
            default: {
                boolean contains = criteria.getApplicableResourceTypes().contains(resourceType);
                ourLog.trace("Subscription {} applicable resource type check: {}", (Object)subscriptionId, (Object)contains);
                return contains;
            }
            case STARTYPE_EXPRESSION: 
        }
        boolean match = !resourceType.equals("Subscription");
        ourLog.trace("Subscription {} start resource type check: {}", (Object)subscriptionId, (Object)match);
        return match;
    }
}

