/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionCanonicalizer;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import jakarta.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionRegisteringListener
implements IMessageListener<ResourceModifiedMessage> {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionRegisteringListener.class);
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private SubscriptionRegistry mySubscriptionRegistry;
    @Autowired
    private SubscriptionCanonicalizer mySubscriptionCanonicalizer;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired(required=false)
    private PartitionSettings myPartitionSettings;

    public Class<ResourceModifiedMessage> getPayloadType() {
        return ResourceModifiedMessage.class;
    }

    public void handleMessage(@Nonnull IMessage<ResourceModifiedMessage> theMessage) {
        ResourceModifiedMessage payload = (ResourceModifiedMessage)theMessage.getPayload();
        if (!payload.hasResourceType(this.myFhirContext, "Subscription")) {
            return;
        }
        switch (payload.getOperationType()) {
            case MANUALLY_TRIGGERED: 
            case TRANSACTION: {
                return;
            }
        }
        IIdType payloadId = payload.getPayloadId(this.myFhirContext).toUnqualifiedVersionless();
        IFhirResourceDao subscriptionDao = this.myDaoRegistry.getResourceDao("Subscription");
        RequestDetails systemRequestDetails = this.getPartitionAwareRequestDetails(payload);
        IBaseResource payloadResource = subscriptionDao.read(payloadId, systemRequestDetails, true);
        if (payloadResource == null) {
            payloadResource = payload.getResource(this.myFhirContext);
        }
        if (payloadResource.isDeleted()) {
            this.mySubscriptionRegistry.unregisterSubscriptionIfRegistered(payloadId.getIdPart());
            return;
        }
        String statusString = this.mySubscriptionCanonicalizer.getSubscriptionStatus(payloadResource);
        if ("active".equals(statusString)) {
            this.mySubscriptionRegistry.registerSubscriptionUnlessAlreadyRegistered(payloadResource);
        } else {
            this.mySubscriptionRegistry.unregisterSubscriptionIfRegistered(payloadId.getIdPart());
        }
    }

    private Integer getDefaultPartitionId() {
        if (this.myPartitionSettings != null) {
            return this.myPartitionSettings.getDefaultPartitionId();
        }
        ourLog.warn("No PartitionSettings available.");
        return null;
    }

    private RequestDetails getPartitionAwareRequestDetails(ResourceModifiedMessage payload) {
        Integer defaultPartitionId = this.getDefaultPartitionId();
        RequestPartitionId payloadPartitionId = payload.getPartitionId();
        if (payloadPartitionId == null || payloadPartitionId.isPartition(defaultPartitionId)) {
            payloadPartitionId = RequestPartitionId.defaultPartition();
        }
        return new SystemRequestDetails().setRequestPartitionId(payloadPartitionId);
    }
}

