/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.registry;

import ca.uhn.fhir.cache.BaseResourceCacheSynchronizer;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionActivatingListener;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionCanonicalizer;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionLoader
extends BaseResourceCacheSynchronizer {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionLoader.class);
    @Autowired
    private SubscriptionRegistry mySubscriptionRegistry;
    @Autowired
    private SubscriptionActivatingListener mySubscriptionActivatingInterceptor;
    @Autowired
    private SubscriptionCanonicalizer mySubscriptionCanonicalizer;
    @Autowired
    protected ISearchParamRegistry mySearchParamRegistry;

    public SubscriptionLoader() {
        super("Subscription");
    }

    @VisibleForTesting
    public int doSyncSubscriptionsForUnitTest() {
        return super.doSyncResourcesForUnitTest();
    }

    @Nonnull
    protected SearchParameterMap getSearchParameterMap() {
        SearchParameterMap map = new SearchParameterMap();
        if (this.mySearchParamRegistry.getActiveSearchParam("Subscription", "status", ISearchParamRegistry.SearchParamLookupContextEnum.ALL) != null) {
            map.add("status", (IQueryParameterOr)new TokenOrListParam().addOr(new TokenParam(null, Subscription.SubscriptionStatus.REQUESTED.toCode())).addOr(new TokenParam(null, Subscription.SubscriptionStatus.ACTIVE.toCode())));
        }
        map.setLoadSynchronousUpTo(Integer.valueOf(10000));
        return map;
    }

    protected void handleInit(List<IBaseResource> resourceList) {
        this.updateSubscriptionRegistry(resourceList);
    }

    protected int syncResourcesIntoCache(List<IBaseResource> resourceList) {
        return this.updateSubscriptionRegistry(resourceList);
    }

    private int updateSubscriptionRegistry(List<IBaseResource> theResourceList) {
        HashSet<String> allIds = new HashSet<String>();
        int activatedCount = 0;
        int registeredCount = 0;
        for (IBaseResource resource : theResourceList) {
            boolean registered;
            String nextId = resource.getIdElement().getIdPart();
            allIds.add(nextId);
            boolean activated = this.activateSubscriptionIfRequested(resource);
            if (activated) {
                ++activatedCount;
            }
            if (!(registered = this.mySubscriptionRegistry.registerSubscriptionUnlessAlreadyRegistered(resource))) continue;
            ++registeredCount;
        }
        this.mySubscriptionRegistry.unregisterAllSubscriptionsNotInCollection(allIds);
        ourLog.debug("Finished sync subscriptions - activated {} and registered {}", (Object)theResourceList.size(), (Object)registeredCount);
        return activatedCount;
    }

    private boolean activateSubscriptionIfRequested(IBaseResource theSubscription) {
        boolean successfullyActivated = false;
        if ("requested".equals(this.mySubscriptionCanonicalizer.getSubscriptionStatus(theSubscription))) {
            if (this.mySubscriptionActivatingInterceptor.isChannelTypeSupported(theSubscription)) {
                if (this.mySubscriptionActivatingInterceptor.activateSubscriptionIfRequired(theSubscription)) {
                    successfullyActivated = true;
                } else {
                    this.logSubscriptionNotActivatedPlusErrorIfPossible(theSubscription);
                }
            } else {
                ourLog.debug("Could not activate subscription {} because channel type {} is not supported.", (Object)theSubscription.getIdElement(), (Object)this.mySubscriptionCanonicalizer.getChannelType(theSubscription));
            }
        }
        return successfullyActivated;
    }

    private void logSubscriptionNotActivatedPlusErrorIfPossible(IBaseResource theSubscription) {
        String error = theSubscription instanceof Subscription ? ((Subscription)theSubscription).getError() : (theSubscription instanceof org.hl7.fhir.dstu3.model.Subscription ? ((org.hl7.fhir.dstu3.model.Subscription)theSubscription).getError() : (theSubscription instanceof org.hl7.fhir.dstu2.model.Subscription ? ((org.hl7.fhir.dstu2.model.Subscription)theSubscription).getError() : ""));
        ourLog.error("Subscription {} could not be activated. This will not prevent startup, but it could lead to undesirable outcomes! {}", (Object)theSubscription.getIdElement().getIdPart(), StringUtils.isBlank((CharSequence)error) ? "" : "Error: " + error);
    }
}

