/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.config;

import ca.uhn.fhir.jpa.subscription.submit.interceptor.SubscriptionMatcherInterceptor;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.SynchronousSubscriptionMatcherInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SubscriptionMatcherInterceptorConfig {
    @Autowired
    private Environment myEnvironment;

    @Bean
    public SubscriptionMatcherInterceptor subscriptionMatcherInterceptor() {
        if (this.isSchedulingDisabledForTests()) {
            return new SynchronousSubscriptionMatcherInterceptor();
        }
        return new SubscriptionMatcherInterceptor();
    }

    private boolean isSchedulingDisabledForTests() {
        String schedulingDisabled = this.myEnvironment.getProperty("scheduling_disabled");
        return "true".equals(schedulingDisabled);
    }
}

