/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.config;

import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.model.config.SubscriptionSettings;
import ca.uhn.fhir.jpa.subscription.async.AsyncResourceModifiedProcessingSchedulerSvc;
import ca.uhn.fhir.jpa.subscription.async.AsyncResourceModifiedSubmitterSvc;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelFactory;
import ca.uhn.fhir.jpa.subscription.config.SubscriptionConfig;
import ca.uhn.fhir.jpa.subscription.model.config.SubscriptionModelConfig;
import ca.uhn.fhir.jpa.subscription.submit.config.SubscriptionMatcherInterceptorConfig;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.SubscriptionMatcherInterceptor;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.SubscriptionSubmitInterceptorLoader;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.SubscriptionValidatingInterceptor;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.validator.IChannelTypeValidator;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.validator.RegexEndpointUrlValidationStrategy;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.validator.RestHookChannelValidator;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.validator.SubscriptionChannelTypeValidatorFactory;
import ca.uhn.fhir.jpa.subscription.submit.svc.ResourceModifiedSubmitterSvc;
import ca.uhn.fhir.jpa.subscription.triggering.ISubscriptionTriggeringSvc;
import ca.uhn.fhir.jpa.subscription.triggering.SubscriptionTriggeringSvcImpl;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicValidatingInterceptor;
import ca.uhn.fhir.subscription.api.IResourceModifiedConsumerWithRetries;
import ca.uhn.fhir.subscription.api.IResourceModifiedMessagePersistenceSvc;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

@Configuration
@Import(value={SubscriptionModelConfig.class, SubscriptionMatcherInterceptorConfig.class, SubscriptionConfig.class})
public class SubscriptionSubmitterConfig {
    @Bean
    public SubscriptionValidatingInterceptor subscriptionValidatingInterceptor() {
        return new SubscriptionValidatingInterceptor();
    }

    @Bean
    public SubscriptionSubmitInterceptorLoader subscriptionMatcherInterceptorLoader(@Nonnull IInterceptorService theInterceptorService, @Nonnull SubscriptionSettings theSubscriptionSettings, @Nonnull SubscriptionMatcherInterceptor theSubscriptionMatcherInterceptor, @Nonnull SubscriptionValidatingInterceptor theSubscriptionValidatingInterceptor, @Nullable SubscriptionTopicValidatingInterceptor theSubscriptionTopicValidatingInterceptor) {
        return new SubscriptionSubmitInterceptorLoader(theInterceptorService, theSubscriptionSettings, theSubscriptionMatcherInterceptor, theSubscriptionValidatingInterceptor, theSubscriptionTopicValidatingInterceptor);
    }

    @Bean
    @Lazy
    public ISubscriptionTriggeringSvc subscriptionTriggeringSvc() {
        return new SubscriptionTriggeringSvcImpl();
    }

    @Bean
    public ResourceModifiedSubmitterSvc resourceModifiedSvc(IHapiTransactionService theHapiTransactionService, IResourceModifiedMessagePersistenceSvc theResourceModifiedMessagePersistenceSvc, SubscriptionChannelFactory theSubscriptionChannelFactory, SubscriptionSettings theSubscriptionSettings) {
        return new ResourceModifiedSubmitterSvc(theSubscriptionSettings, theSubscriptionChannelFactory, theResourceModifiedMessagePersistenceSvc, theHapiTransactionService);
    }

    @Bean
    public AsyncResourceModifiedProcessingSchedulerSvc asyncResourceModifiedProcessingSchedulerSvc(SubscriptionConfig subscriptionConfig, SubscriptionSettings theSubscriptionSettings) {
        return new AsyncResourceModifiedProcessingSchedulerSvc(theSubscriptionSettings.getSubscriptionIntervalInMs());
    }

    @Bean
    public AsyncResourceModifiedSubmitterSvc asyncResourceModifiedSubmitterSvc(IResourceModifiedMessagePersistenceSvc theIResourceModifiedMessagePersistenceSvc, IResourceModifiedConsumerWithRetries theResourceModifiedConsumer) {
        return new AsyncResourceModifiedSubmitterSvc(theIResourceModifiedMessagePersistenceSvc, theResourceModifiedConsumer);
    }

    @Bean
    public IChannelTypeValidator restHookChannelValidator(SubscriptionSettings theSubscriptionSettings) {
        RestHookChannelValidator.IEndpointUrlValidationStrategy iEndpointUrlValidationStrategy = RestHookChannelValidator.noOpEndpointUrlValidationStrategy;
        if (theSubscriptionSettings.hasRestHookEndpointUrlValidationRegex()) {
            String endpointUrlValidationRegex = theSubscriptionSettings.getRestHookEndpointUrlValidationRegex();
            iEndpointUrlValidationStrategy = new RegexEndpointUrlValidationStrategy(endpointUrlValidationRegex);
        }
        return new RestHookChannelValidator(iEndpointUrlValidationStrategy);
    }

    @Bean
    public SubscriptionChannelTypeValidatorFactory subscriptionChannelTypeValidatorFactory(List<IChannelTypeValidator> theValidorList) {
        return new SubscriptionChannelTypeValidatorFactory(theValidorList);
    }
}

