/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.model.config.SubscriptionSettings;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionMatchingStrategy;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionStrategyEvaluator;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionCanonicalizer;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.validator.IChannelTypeValidator;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.validator.SubscriptionChannelTypeValidatorFactory;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.validator.SubscriptionQueryValidator;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.util.SubscriptionUtil;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Subscription;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class SubscriptionValidatingInterceptor {
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private SubscriptionSettings mySubscriptionSettings;
    @Autowired
    private SubscriptionStrategyEvaluator mySubscriptionStrategyEvaluator;
    @Autowired
    private SubscriptionCanonicalizer mySubscriptionCanonicalizer;
    private FhirContext myFhirContext;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    @Autowired
    private SubscriptionQueryValidator mySubscriptionQueryValidator;
    @Autowired
    private SubscriptionChannelTypeValidatorFactory mySubscriptionChannelTypeValidatorFactory;

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED, order=100)
    public void resourcePreCreate(IBaseResource theResource, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        this.validateSubmittedSubscription(theResource, theRequestDetails, theRequestPartitionId, Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED, order=100)
    public void resourceUpdated(IBaseResource theOldResource, IBaseResource theResource, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        this.validateSubmittedSubscription(theResource, theRequestDetails, theRequestPartitionId, Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED);
    }

    @Autowired
    public void setFhirContext(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    @VisibleForTesting
    void validateSubmittedSubscription(IBaseResource theSubscription, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId, Pointcut thePointcut) {
        CanonicalSubscription subscription;
        if (Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED != thePointcut && Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED != thePointcut) {
            throw new UnprocessableEntityException(Msg.code((int)2267) + "Expected Pointcut to be either STORAGE_PRESTORAGE_RESOURCE_CREATED or STORAGE_PRESTORAGE_RESOURCE_UPDATED but was: " + String.valueOf(thePointcut));
        }
        if (!"Subscription".equals(this.myFhirContext.getResourceType(theSubscription))) {
            return;
        }
        try {
            subscription = this.mySubscriptionCanonicalizer.canonicalize(theSubscription);
        }
        catch (InternalErrorException e) {
            throw new UnprocessableEntityException(Msg.code((int)955) + e.getMessage());
        }
        boolean finished = false;
        if (subscription.getStatus() == null) {
            throw new UnprocessableEntityException(Msg.code((int)8) + "Can not process submitted Subscription - Subscription.status must be populated on this server");
        }
        switch (subscription.getStatus()) {
            case REQUESTED: 
            case ACTIVE: {
                break;
            }
            case ERROR: 
            case OFF: 
            case NULL: {
                finished = true;
            }
        }
        this.validatePermissions(theSubscription, theRequestDetails, theRequestPartitionId, thePointcut);
        this.mySubscriptionCanonicalizer.setMatchingStrategyTag(theSubscription, null);
        if (!finished) {
            if (subscription.getPayloadSearchCriteria() != null) {
                this.validateQuery(subscription.getPayloadSearchCriteria(), "Subscription.extension(url='http://hapifhir.io/fhir/StructureDefinition/subscription-payload-search-criteria')");
            }
            this.validateCriteria(theSubscription, subscription);
            this.validateChannelType(subscription);
            try {
                SubscriptionMatchingStrategy strategy = this.mySubscriptionStrategyEvaluator.determineStrategy(subscription);
                if (SubscriptionMatchingStrategy.IN_MEMORY != strategy && this.mySubscriptionSettings.isOnlyAllowInMemorySubscriptions()) {
                    throw new InvalidRequestException(Msg.code((int)2367) + "This server is configured to only allow in-memory subscriptions. This subscription's criteria cannot be evaluated in-memory.");
                }
                this.mySubscriptionCanonicalizer.setMatchingStrategyTag(theSubscription, strategy);
            }
            catch (DataFormatException | InvalidRequestException e) {
                throw new UnprocessableEntityException(Msg.code((int)9) + "Invalid subscription criteria submitted: " + subscription.getCriteriaString() + " " + e.getMessage());
            }
            if (subscription.getChannelType() == null) {
                throw new UnprocessableEntityException(Msg.code((int)10) + "Subscription.channel.type must be populated on this server");
            }
            if (subscription.getChannelType() == CanonicalSubscriptionChannelType.MESSAGE) {
                this.validateMessageSubscriptionEndpoint(subscription.getEndpointUrl());
            }
        }
    }

    private void validateCriteria(IBaseResource theSubscription, CanonicalSubscription theCanonicalSubscription) {
        if (theCanonicalSubscription.isTopicSubscription()) {
            if (this.myFhirContext.getVersion().getVersion() == FhirVersionEnum.R4) {
                this.validateR4BackportSubscription((Subscription)theSubscription);
            } else {
                this.validateR5PlusTopicSubscription(theCanonicalSubscription);
            }
        } else {
            this.validateQuery(theCanonicalSubscription.getCriteriaString(), "Subscription.criteria");
        }
    }

    private void validateR5PlusTopicSubscription(CanonicalSubscription theCanonicalSubscription) {
        Optional<IBaseResource> oTopic = this.findSubscriptionTopicByUrl(theCanonicalSubscription.getTopic());
        if (!oTopic.isPresent()) {
            throw new UnprocessableEntityException(Msg.code((int)2322) + "No SubscriptionTopic exists with topic: " + theCanonicalSubscription.getTopic());
        }
    }

    private void validateR4BackportSubscription(Subscription theSubscription) {
        Subscription r4Subscription = theSubscription;
        ArrayList filterUrls = new ArrayList();
        List filterUrlExtensions = r4Subscription.getCriteriaElement().getExtensionsByUrl("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-filter-criteria");
        filterUrlExtensions.forEach(filterUrlExtension -> {
            StringType filterUrlElement = (StringType)filterUrlExtension.getValue();
            if (filterUrlElement != null) {
                filterUrls.add((String)filterUrlElement.getValue());
            }
        });
        if (filterUrls.isEmpty()) {
            this.validateQuery(null, "Subscription.criteria.extension with url http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-filter-criteria");
        } else {
            filterUrls.forEach(filterUrl -> this.validateQuery((String)filterUrl, "Subscription.criteria.extension with url http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-filter-criteria"));
        }
    }

    protected void validatePermissions(IBaseResource theSubscription, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId, Pointcut thePointcut) {
        if (SubscriptionUtil.isDefinedAsCrossPartitionSubcription((IBaseResource)theSubscription) && !(theRequestDetails instanceof SystemRequestDetails)) {
            RequestPartitionId toCheckPartitionId;
            if (!this.mySubscriptionSettings.isCrossPartitionSubscriptionEnabled()) {
                throw new UnprocessableEntityException(Msg.code((int)2009) + "Cross partition subscription is not enabled on this server");
            }
            if (theRequestPartitionId == null && Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED == thePointcut) {
                return;
            }
            RequestPartitionId requestPartitionId = toCheckPartitionId = theRequestPartitionId != null ? theRequestPartitionId : this.determinePartition(theRequestDetails, theSubscription);
            if (!this.myRequestPartitionHelperSvc.isDefaultPartition(toCheckPartitionId)) {
                throw new UnprocessableEntityException(Msg.code((int)2010) + "Cross partition subscription must be created on the default partition");
            }
        }
    }

    private RequestPartitionId determinePartition(RequestDetails theRequestDetails, IBaseResource theResource) {
        switch (theRequestDetails.getRestOperationType()) {
            case CREATE: {
                return this.myRequestPartitionHelperSvc.determineCreatePartitionForRequest(theRequestDetails, theResource, "Subscription");
            }
            case UPDATE: {
                return this.myRequestPartitionHelperSvc.determineReadPartitionForRequestForRead(theRequestDetails, "Subscription", theResource.getIdElement());
            }
        }
        return null;
    }

    public void validateQuery(String theQuery, String theFieldName) {
        this.mySubscriptionQueryValidator.validateCriteria(theQuery, theFieldName);
    }

    private Optional<IBaseResource> findSubscriptionTopicByUrl(String theCriteria) {
        this.myDaoRegistry.getResourceDao("SubscriptionTopic");
        SearchParameterMap map = SearchParameterMap.newSynchronous();
        map.add("url", (IQueryParameterType)new UriParam(theCriteria));
        IFhirResourceDao subscriptionTopicDao = this.myDaoRegistry.getResourceDao("SubscriptionTopic");
        IBundleProvider search = subscriptionTopicDao.search(map, (RequestDetails)new SystemRequestDetails());
        return search.getResources(0, 1).stream().findFirst();
    }

    public void validateMessageSubscriptionEndpoint(String theEndpointUrl) {
        if (theEndpointUrl == null) {
            throw new UnprocessableEntityException(Msg.code((int)16) + "No endpoint defined for message subscription");
        }
        try {
            URI uri = new URI(theEndpointUrl);
            if (!"channel".equals(uri.getScheme())) {
                throw new UnprocessableEntityException(Msg.code((int)17) + "Only 'channel' protocol is supported for Subscriptions with channel type 'message'");
            }
            String channelName = uri.getSchemeSpecificPart();
            if (StringUtils.isBlank((CharSequence)channelName)) {
                throw new UnprocessableEntityException(Msg.code((int)18) + "A channel name must appear after channel: in a message Subscription endpoint");
            }
        }
        catch (URISyntaxException e) {
            throw new UnprocessableEntityException(Msg.code((int)19) + "Invalid subscription endpoint uri " + theEndpointUrl, (Throwable)e);
        }
    }

    protected void validateChannelType(CanonicalSubscription theSubscription) {
        if (theSubscription.getChannelType() == null) {
            throw new UnprocessableEntityException(Msg.code((int)20) + "Subscription.channel.type must be populated");
        }
        IChannelTypeValidator iChannelTypeValidator = this.mySubscriptionChannelTypeValidatorFactory.getValidatorForChannelType(theSubscription.getChannelType());
        iChannelTypeValidator.validateChannelType(theSubscription);
    }

    @VisibleForTesting
    public void setSubscriptionCanonicalizerForUnitTest(SubscriptionCanonicalizer theSubscriptionCanonicalizer) {
        this.mySubscriptionCanonicalizer = theSubscriptionCanonicalizer;
    }

    @VisibleForTesting
    public void setDaoRegistryForUnitTest(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    @VisibleForTesting
    public void setSubscriptionSettingsForUnitTest(SubscriptionSettings theSubscriptionSettings) {
        this.mySubscriptionSettings = theSubscriptionSettings;
    }

    @VisibleForTesting
    public void setRequestPartitionHelperSvcForUnitTest(IRequestPartitionHelperSvc theRequestPartitionHelperSvc) {
        this.myRequestPartitionHelperSvc = theRequestPartitionHelperSvc;
    }

    @VisibleForTesting
    public void setSubscriptionStrategyEvaluatorForUnitTest(SubscriptionStrategyEvaluator theSubscriptionStrategyEvaluator) {
        this.mySubscriptionStrategyEvaluator = theSubscriptionStrategyEvaluator;
        this.mySubscriptionQueryValidator = new SubscriptionQueryValidator(this.myDaoRegistry, theSubscriptionStrategyEvaluator);
    }

    @VisibleForTesting
    public void setSubscriptionChannelTypeValidatorFactoryForUnitTest(SubscriptionChannelTypeValidatorFactory theSubscriptionChannelTypeValidatorFactory) {
        this.mySubscriptionChannelTypeValidatorFactory = theSubscriptionChannelTypeValidatorFactory;
    }
}

