/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.interceptor;

import ca.uhn.fhir.broker.api.ISendResult;
import ca.uhn.fhir.broker.api.PayloadTooLargeException;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.IResourceModifiedConsumer;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.SubscriptionMatcherInterceptor;
import ca.uhn.fhir.util.Logs;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SynchronousSubscriptionMatcherInterceptor
extends SubscriptionMatcherInterceptor {
    private static final Logger ourLog = Logs.getSubscriptionTroubleshootingLog();
    @Autowired
    private IResourceModifiedConsumer myResourceModifiedConsumer;

    @Override
    protected void processResourceModifiedMessage(final ResourceModifiedMessage theResourceModifiedMessage) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public int getOrder() {
                    return 0;
                }

                public void afterCommit() {
                    SynchronousSubscriptionMatcherInterceptor.this.doSubmitResourceModified(theResourceModifiedMessage);
                }
            });
        } else {
            this.doSubmitResourceModified(theResourceModifiedMessage);
        }
    }

    private ISendResult doSubmitResourceModified(ResourceModifiedMessage theResourceModifiedMessage) {
        try {
            ISendResult retval = this.myResourceModifiedConsumer.submitResourceModified(theResourceModifiedMessage);
            if (!retval.isSuccessful()) {
                ourLog.warn("Failed to send message to Delivery Channel.");
            }
            return retval;
        }
        catch (Exception e) {
            if (e instanceof PayloadTooLargeException || e.getCause() instanceof PayloadTooLargeException) {
                ourLog.warn("Failed to send message to Subscription Matching Channel because the payload size is larger than broker max message size. Retry is about to be performed without payload.");
                theResourceModifiedMessage.setPayloadToNull();
                return this.myResourceModifiedConsumer.submitResourceModified(theResourceModifiedMessage);
            }
            ourLog.error("Failed to send message to Subscription Matching Channel", (Throwable)e);
            throw e;
        }
    }
}

