/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.interceptor.validator;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.validator.IChannelTypeValidator;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class RestHookChannelValidator
implements IChannelTypeValidator {
    private final IEndpointUrlValidationStrategy myEndpointUrlValidationStrategy;
    public static final IEndpointUrlValidationStrategy noOpEndpointUrlValidationStrategy = theEndpointUrl -> {};

    public RestHookChannelValidator() {
        this(noOpEndpointUrlValidationStrategy);
    }

    public RestHookChannelValidator(@Nonnull IEndpointUrlValidationStrategy theEndpointUrlValidationStrategy) {
        this.myEndpointUrlValidationStrategy = theEndpointUrlValidationStrategy;
    }

    @Override
    public void validateChannelType(CanonicalSubscription theSubscription) {
        this.validateChannelPayload(theSubscription);
        this.validateChannelEndpoint(theSubscription);
    }

    @Override
    public CanonicalSubscriptionChannelType getSubscriptionChannelType() {
        return CanonicalSubscriptionChannelType.RESTHOOK;
    }

    protected void validateChannelEndpoint(@Nonnull CanonicalSubscription theCanonicalSubscription) {
        String endpointUrl = theCanonicalSubscription.getEndpointUrl();
        if (StringUtils.isBlank((CharSequence)endpointUrl)) {
            throw new UnprocessableEntityException(Msg.code((int)21) + "Rest-hook subscriptions must have Subscription.channel.endpoint defined");
        }
        this.myEndpointUrlValidationStrategy.validateEndpointUrl(endpointUrl);
    }

    protected void validateChannelPayload(CanonicalSubscription theResource) {
        if (!StringUtils.isBlank((CharSequence)theResource.getPayloadString()) && EncodingEnum.forContentType((String)theResource.getPayloadString()) == null) {
            throw new UnprocessableEntityException(Msg.code((int)1985) + "Invalid value for Subscription.channel.payload: " + theResource.getPayloadString());
        }
    }

    public static interface IEndpointUrlValidationStrategy {
        public void validateEndpointUrl(String var1);
    }
}

