/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.interceptor.validator;

import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.validator.IChannelTypeValidator;
import jakarta.annotation.Nonnull;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionChannelTypeValidatorFactory {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionChannelTypeValidatorFactory.class);
    private final Map<CanonicalSubscriptionChannelType, IChannelTypeValidator> myValidators = new EnumMap<CanonicalSubscriptionChannelType, IChannelTypeValidator>(CanonicalSubscriptionChannelType.class);

    public SubscriptionChannelTypeValidatorFactory(@Nonnull List<IChannelTypeValidator> theValidorList) {
        theValidorList.forEach(this::addChannelTypeValidator);
    }

    public IChannelTypeValidator getValidatorForChannelType(CanonicalSubscriptionChannelType theChannelType) {
        return this.myValidators.getOrDefault(theChannelType, this.getNoopValidatorForChannelType(theChannelType));
    }

    public void addChannelTypeValidator(IChannelTypeValidator theValidator) {
        this.myValidators.put(theValidator.getSubscriptionChannelType(), theValidator);
    }

    private IChannelTypeValidator getNoopValidatorForChannelType(final CanonicalSubscriptionChannelType theChannelType) {
        return new IChannelTypeValidator(){

            @Override
            public void validateChannelType(CanonicalSubscription theSubscription) {
                ourLog.debug("No validator for channel type {} was registered, will perform no-op validation.", (Object)theChannelType);
            }

            @Override
            public CanonicalSubscriptionChannelType getSubscriptionChannelType() {
                return theChannelType;
            }
        };
    }
}

