/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.svc;

import ca.uhn.fhir.broker.api.ChannelProducerSettings;
import ca.uhn.fhir.broker.api.IChannelProducer;
import ca.uhn.fhir.broker.api.ISendResult;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.model.config.SubscriptionSettings;
import ca.uhn.fhir.jpa.model.entity.IPersistedResourceModifiedMessage;
import ca.uhn.fhir.jpa.model.entity.IPersistedResourceModifiedMessagePK;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelFactory;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.IResourceModifiedConsumer;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import ca.uhn.fhir.subscription.api.IResourceModifiedConsumerWithRetries;
import ca.uhn.fhir.subscription.api.IResourceModifiedMessagePersistenceSvc;
import ca.uhn.fhir.util.IoUtils;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PreDestroy;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.support.TransactionCallback;

public class ResourceModifiedSubmitterSvc
implements IResourceModifiedConsumer,
IResourceModifiedConsumerWithRetries {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceModifiedSubmitterSvc.class);
    private volatile IChannelProducer<ResourceModifiedMessage> myMatchingChannelProducer;
    private final SubscriptionSettings mySubscriptionSettings;
    private final SubscriptionChannelFactory mySubscriptionChannelFactory;
    private final IResourceModifiedMessagePersistenceSvc myResourceModifiedMessagePersistenceSvc;
    private final IHapiTransactionService myHapiTransactionService;

    @EventListener(classes={ContextRefreshedEvent.class})
    public void startIfNeeded() {
        if (!this.mySubscriptionSettings.hasSupportedSubscriptionTypes()) {
            ourLog.debug("Subscriptions are disabled on this server.  Skipping {} channel creation.", (Object)"subscription-matching");
            return;
        }
        if (this.myMatchingChannelProducer == null) {
            this.myMatchingChannelProducer = this.mySubscriptionChannelFactory.newMatchingProducer("subscription-matching", this.getChannelProducerSettings());
        }
    }

    public ResourceModifiedSubmitterSvc(SubscriptionSettings theSubscriptionSettings, SubscriptionChannelFactory theSubscriptionChannelFactory, IResourceModifiedMessagePersistenceSvc resourceModifiedMessagePersistenceSvc, IHapiTransactionService theHapiTransactionService) {
        this.mySubscriptionSettings = theSubscriptionSettings;
        this.mySubscriptionChannelFactory = theSubscriptionChannelFactory;
        this.myResourceModifiedMessagePersistenceSvc = resourceModifiedMessagePersistenceSvc;
        this.myHapiTransactionService = theHapiTransactionService;
    }

    public ISendResult submitResourceModified(ResourceModifiedMessage theMsg) {
        this.startIfNeeded();
        ourLog.trace("Sending resource modified message to processing channel");
        Validate.notNull(this.myMatchingChannelProducer, (String)"A SubscriptionMatcherInterceptor has been registered without calling start() on it.", (Object[])new Object[0]);
        return this.myMatchingChannelProducer.send((IMessage)new ResourceModifiedJsonMessage(theMsg));
    }

    public boolean submitPersisedResourceModifiedMessage(IPersistedResourceModifiedMessage thePersistedResourceModifiedMessage) {
        return (Boolean)this.myHapiTransactionService.withSystemRequest().withPropagation(Propagation.REQUIRES_NEW).execute(this.doProcessResourceModifiedInTransaction(thePersistedResourceModifiedMessage));
    }

    protected TransactionCallback<Boolean> doProcessResourceModifiedInTransaction(IPersistedResourceModifiedMessage thePersistedResourceModifiedMessage) {
        return theStatus -> {
            boolean processed = true;
            ResourceModifiedMessage resourceModifiedMessage = null;
            try {
                boolean wasDeleted = this.deletePersistedResourceModifiedMessage(thePersistedResourceModifiedMessage.getPersistedResourceModifiedMessagePk());
                resourceModifiedMessage = this.createResourceModifiedMessageWithoutInflation(thePersistedResourceModifiedMessage);
                if (wasDeleted) {
                    this.submitResourceModified(resourceModifiedMessage);
                }
            }
            catch (MessageDeliveryException exception) {
                String payloadId = "[unknown]";
                String subscriptionId = "[unknown]";
                if (resourceModifiedMessage != null) {
                    payloadId = resourceModifiedMessage.getPayloadId();
                    subscriptionId = resourceModifiedMessage.getSubscriptionId();
                }
                ourLog.error("Channel submission failed for resource with id {} matching subscription with id {}.  Further attempts will be performed at later time.", new Object[]{payloadId, subscriptionId, exception});
                processed = false;
                theStatus.setRollbackOnly();
            }
            catch (Exception ex) {
                ourLog.error("Unexpected error encountered while processing resource modified message. Marking as processed to prevent further errors.", (Throwable)ex);
                processed = true;
            }
            return processed;
        };
    }

    private ResourceModifiedMessage createResourceModifiedMessageWithoutInflation(IPersistedResourceModifiedMessage thePersistedResourceModifiedMessage) {
        return this.myResourceModifiedMessagePersistenceSvc.createResourceModifiedMessageFromEntityWithoutInflation(thePersistedResourceModifiedMessage);
    }

    private boolean deletePersistedResourceModifiedMessage(IPersistedResourceModifiedMessagePK theResourceModifiedPK) {
        try {
            return this.myResourceModifiedMessagePersistenceSvc.deleteByPK(theResourceModifiedPK);
        }
        catch (ResourceNotFoundException exception) {
            ourLog.warn("thePersistedResourceModifiedMessage with {} and version {} could not be deleted as it may have already been deleted.", (Object)theResourceModifiedPK.getResourcePid(), (Object)theResourceModifiedPK.getResourceVersion());
            return false;
        }
        catch (Exception ex) {
            ourLog.error("Unknown exception when deleting persisted resource modified message. Returning false.", (Throwable)ex);
            return false;
        }
    }

    private ChannelProducerSettings getChannelProducerSettings() {
        ChannelProducerSettings channelProducerSettings = new ChannelProducerSettings();
        channelProducerSettings.setQualifyChannelName(this.mySubscriptionSettings.isQualifySubscriptionMatchingChannelName());
        return channelProducerSettings;
    }

    @PreDestroy
    public void shutdown() throws Exception {
        IChannelProducer<ResourceModifiedMessage> iChannelProducer = this.myMatchingChannelProducer;
        if (iChannelProducer instanceof AutoCloseable) {
            AutoCloseable producer = (AutoCloseable)iChannelProducer;
            IoUtils.closeQuietly((AutoCloseable)producer, (Logger)ourLog);
        }
    }

    @VisibleForTesting
    public IChannelProducer<ResourceModifiedMessage> getMatchingChannelProducerForUnitTest() {
        this.startIfNeeded();
        return this.myMatchingChannelProducer;
    }
}

