/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.config.SubscriptionSettings;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionCanonicalizer;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.hapi.converters.canonical.SubscriptionTopicCanonicalizer;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class SubscriptionRulesInterceptor {
    public static final String CRITERIA_WITH_AT_LEAST_ONE_PARAM = "^[A-Z][A-Za-z0-9]++\\?[a-z].*";
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionRulesInterceptor.class);
    private final List<Pattern> myAllowedCriteriaPatterns = new ArrayList<Pattern>();
    private final FhirContext myFhirContext;
    private final FhirVersionEnum myVersion;
    private final SubscriptionCanonicalizer mySubscriptionCanonicalizer;
    private boolean myValidateRestHookEndpointIsReachable;

    public SubscriptionRulesInterceptor(@Nonnull FhirContext theFhirContext, @Nonnull SubscriptionSettings theSubscriptionSettings, PartitionSettings thePartitionSettings) {
        Validate.notNull((Object)theFhirContext, (String)"FhirContext must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theSubscriptionSettings, (String)"SubscriptionSettings must not be null", (Object[])new Object[0]);
        this.myFhirContext = theFhirContext;
        this.myVersion = this.myFhirContext.getVersion().getVersion();
        this.mySubscriptionCanonicalizer = new SubscriptionCanonicalizer(this.myFhirContext, theSubscriptionSettings, thePartitionSettings);
    }

    public void addAllowedCriteriaPattern(@Nonnull String theAllowedCriteriaPattern) {
        Validate.notBlank((CharSequence)theAllowedCriteriaPattern, (String)"Allowed criteria pattern must not be null", (Object[])new Object[0]);
        this.myAllowedCriteriaPatterns.add(Pattern.compile(theAllowedCriteriaPattern));
    }

    public void setValidateRestHookEndpointIsReachable(boolean theValidateRestHookEndpointIsReachable) {
        this.myValidateRestHookEndpointIsReachable = theValidateRestHookEndpointIsReachable;
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void validateCreate(IBaseResource theResource) {
        this.checkResource(theResource);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void validateUpdate(IBaseResource theOldResource, IBaseResource theResource) {
        this.checkResource(theResource);
    }

    private void checkResource(IBaseResource theResource) {
        if (this.myVersion.isEqualOrNewerThan(FhirVersionEnum.R4B)) {
            if ("SubscriptionTopic".equals(this.myFhirContext.getResourceType(theResource))) {
                this.validateSubscriptionTopic(theResource);
            }
        } else if (this.myVersion.equals((Object)FhirVersionEnum.R4) && "Basic".equals(this.myFhirContext.getResourceType(theResource))) {
            this.validateSubscriptionTopic(theResource);
        }
        if (this.myVersion.isOlderThan(FhirVersionEnum.R5) && "Subscription".equals(this.myFhirContext.getResourceType(theResource))) {
            this.validateSubscription(theResource);
        }
    }

    private void validateSubscriptionTopic(IBaseResource theResource) {
        SubscriptionTopic topic = SubscriptionTopicCanonicalizer.canonicalizeTopic((FhirContext)this.myFhirContext, (IBaseResource)theResource);
        if (topic != null) {
            ourLog.info("Validating SubscriptionTopic: {}", (Object)theResource.getIdElement());
            for (SubscriptionTopic.SubscriptionTopicResourceTriggerComponent resourceTrigger : topic.getResourceTrigger()) {
                String criteriaString = resourceTrigger.getQueryCriteria().getCurrent();
                this.validateCriteriaString(criteriaString);
            }
        }
    }

    private void validateSubscription(IBaseResource theResource) {
        ourLog.info("Validating Subscription: {}", (Object)theResource.getIdElement());
        CanonicalSubscription canonicalizedSubscription = this.mySubscriptionCanonicalizer.canonicalize(theResource);
        this.validateCriteriaString(canonicalizedSubscription.getCriteriaString());
        this.validateEndpointIsReachable(canonicalizedSubscription);
    }

    private void validateEndpointIsReachable(CanonicalSubscription canonicalizedSubscription) {
        if (this.myValidateRestHookEndpointIsReachable && canonicalizedSubscription.getChannelType() == CanonicalSubscriptionChannelType.RESTHOOK) {
            String endpointUrl = canonicalizedSubscription.getEndpointUrl();
            IGenericClient client = this.myFhirContext.newRestfulGenericClient(endpointUrl);
            Class capabilityStatement = this.myFhirContext.getResourceDefinition("CapabilityStatement").getImplementingClass();
            try {
                client.capabilities().ofType(capabilityStatement).execute();
            }
            catch (Exception e) {
                String message = "REST HOOK endpoint is not reachable: " + endpointUrl;
                ourLog.warn(message);
                throw new PreconditionFailedException(Msg.code((int)2671) + message);
            }
        }
    }

    private void validateCriteriaString(String theCriteriaString) {
        if (!this.myAllowedCriteriaPatterns.isEmpty()) {
            for (Pattern pattern : this.myAllowedCriteriaPatterns) {
                if (!pattern.matcher(theCriteriaString).matches()) continue;
                return;
            }
            String message = "Criteria is not permitted on this server: " + theCriteriaString;
            ourLog.warn(message);
            throw new PreconditionFailedException(Msg.code((int)2672) + message);
        }
    }
}

