/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hl7.fhir.r5.model.SubscriptionTopic;

public class ActiveSubscriptionTopicCache {
    private final Map<String, SubscriptionTopic> myCache = new ConcurrentHashMap<String, SubscriptionTopic>();

    public int size() {
        return this.myCache.size();
    }

    public boolean add(SubscriptionTopic theSubscriptionTopic) {
        String key = theSubscriptionTopic.getIdElement().getIdPart();
        SubscriptionTopic previousValue = this.myCache.put(key, theSubscriptionTopic);
        return previousValue == null;
    }

    public int removeIdsNotInCollection(Set<String> theIdsToRetain) {
        int retval = 0;
        HashSet<String> safeCopy = new HashSet<String>(this.myCache.keySet());
        for (String next : safeCopy) {
            if (theIdsToRetain.contains(next)) continue;
            this.myCache.remove(next);
            ++retval;
        }
        return retval;
    }

    public Collection<SubscriptionTopic> getAll() {
        return this.myCache.values();
    }

    public void remove(String theSubscriptionTopicId) {
        this.myCache.remove(theSubscriptionTopicId);
    }

    public Optional<SubscriptionTopic> findSubscriptionTopicByUrl(String theTopicUrl) {
        return this.myCache.values().stream().filter(t -> t.getUrl().equals(theTopicUrl)).findFirst();
    }
}

