/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.cache.BaseResourceCacheSynchronizer;
import ca.uhn.fhir.jpa.cache.IResourceChangeListener;
import ca.uhn.fhir.jpa.topic.ISubscriptionTopicLoader;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicRegistry;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.Logs;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;

public abstract class BaseSubscriptionTopicLoader
extends BaseResourceCacheSynchronizer
implements ISubscriptionTopicLoader,
IResourceChangeListener {
    private static final Logger ourLog = Logs.getSubscriptionTopicLog();
    private final SubscriptionTopicRegistry mySubscriptionTopicRegistry;
    protected final ISearchParamRegistry mySearchParamRegistry;
    private final VersionCanonicalizer myVersionCanonicalizer;

    public BaseSubscriptionTopicLoader(VersionCanonicalizer theVersionCanonicalizer, String theResourceName, SubscriptionTopicRegistry theSubscriptionTopicRegistry, ISearchParamRegistry theSearchParamRegistry) {
        super(theResourceName);
        this.myVersionCanonicalizer = theVersionCanonicalizer;
        this.mySubscriptionTopicRegistry = theSubscriptionTopicRegistry;
        this.mySearchParamRegistry = theSearchParamRegistry;
    }

    public void handleInit(@Nonnull List<IBaseResource> resourceList) {
        this.updateSubscriptionTopicRegistry(resourceList);
    }

    public int syncResourcesIntoCache(@Nonnull List<IBaseResource> resourceList) {
        return this.updateSubscriptionTopicRegistry(resourceList);
    }

    protected int updateSubscriptionTopicRegistry(List<IBaseResource> theResourceList) {
        HashSet<String> allIds = new HashSet<String>();
        int registeredCount = 0;
        for (IBaseResource resource : theResourceList) {
            String nextId = resource.getIdElement().getIdPart();
            allIds.add(nextId);
            boolean registered = this.mySubscriptionTopicRegistry.register(this.myVersionCanonicalizer.subscriptionTopicToCanonical(resource));
            if (!registered) continue;
            ++registeredCount;
        }
        this.mySubscriptionTopicRegistry.unregisterAllIdsNotInCollection(allIds);
        ourLog.debug("Finished syncing Subscription Topics - registered {}", (Object)registeredCount);
        return registeredCount;
    }
}

