/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.i18n.Msg;
import java.util.Date;
import org.hl7.fhir.r4.model.Basic;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;

public class R4SubscriptionTopicBuilder {
    private final Basic myTopic = new Basic();
    private Extension myCurrentResourceTrigger;
    private Extension myCurrentCanFilterBy;
    private Extension myCurrentNotificationShape;

    public R4SubscriptionTopicBuilder() {
        CodeableConcept code = new CodeableConcept();
        code.addCoding(new Coding().setSystem("http://hl7.org/fhir/fhir-types").setCode("SubscriptionTopic"));
        this.myTopic.setCode(code);
    }

    public R4SubscriptionTopicBuilder setId(String theId) {
        this.myTopic.setId(theId);
        return this;
    }

    public R4SubscriptionTopicBuilder setUrl(String theUrl) {
        this.addExtension("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.url", (Type)new UriType(theUrl));
        return this;
    }

    public R4SubscriptionTopicBuilder setVersion(String theVersion) {
        this.addExtension("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.version", (Type)new StringType(theVersion));
        return this;
    }

    public R4SubscriptionTopicBuilder setName(String theName) {
        this.addExtension("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.name", (Type)new StringType(theName));
        return this;
    }

    public R4SubscriptionTopicBuilder setTitle(String theTitle) {
        this.addExtension("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.title", (Type)new StringType(theTitle));
        return this;
    }

    public R4SubscriptionTopicBuilder setDate(Date theDate) {
        this.addExtension("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.date", (Type)new DateTimeType(theDate));
        return this;
    }

    public R4SubscriptionTopicBuilder setDescription(String theDescription) {
        this.addExtension("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.description", (Type)new MarkdownType(theDescription));
        return this;
    }

    public R4SubscriptionTopicBuilder setStatus(Enumerations.PublicationStatus theStatus) {
        Extension statusExtension = new Extension().setUrl("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.status").setValue((Type)new StringType(theStatus.toCode()));
        this.myTopic.addModifierExtension(statusExtension);
        return this;
    }

    public R4SubscriptionTopicBuilder addResourceTrigger() {
        this.myCurrentResourceTrigger = new Extension().setUrl("http://hl7.org/fhir/4.3/StructureDefinition/extension-SubscriptionTopic.resourceTrigger");
        this.myTopic.addExtension(this.myCurrentResourceTrigger);
        return this;
    }

    public R4SubscriptionTopicBuilder setResourceTriggerDescription(String theDescription) {
        this.checkCurrentResourceTrigger();
        this.addNestedExtension(this.myCurrentResourceTrigger, "description", (Type)new MarkdownType(theDescription));
        return this;
    }

    public R4SubscriptionTopicBuilder setResourceTriggerResource(String theResourceType) {
        this.checkCurrentResourceTrigger();
        this.addNestedExtension(this.myCurrentResourceTrigger, "resource", (Type)new UriType(theResourceType));
        return this;
    }

    public R4SubscriptionTopicBuilder addResourceTriggerSupportedInteraction(String theInteractionCode) {
        this.checkCurrentResourceTrigger();
        this.addNestedExtension(this.myCurrentResourceTrigger, "supportedInteraction", (Type)new StringType(theInteractionCode));
        return this;
    }

    public R4SubscriptionTopicBuilder setResourceTriggerFhirPathCriteria(String theFhirPathExpression) {
        this.checkCurrentResourceTrigger();
        this.addNestedExtension(this.myCurrentResourceTrigger, "fhirPathCriteria", (Type)new StringType(theFhirPathExpression));
        return this;
    }

    public R4SubscriptionTopicBuilder addResourceTriggerQueryCriteria() {
        this.checkCurrentResourceTrigger();
        Extension queryCriteria = new Extension().setUrl("queryCriteria");
        this.myCurrentResourceTrigger.addExtension(queryCriteria);
        return this;
    }

    public R4SubscriptionTopicBuilder setResourceTriggerQueryCriteriaPrevious(String thePreviousQuery) {
        this.checkCurrentResourceTrigger();
        Extension queryCriteria = this.getOrCreateQueryCriteriaExtension();
        queryCriteria.addExtension(new Extension().setUrl("previous").setValue((Type)new StringType(thePreviousQuery)));
        return this;
    }

    public R4SubscriptionTopicBuilder setResourceTriggerQueryCriteriaCurrent(String theCurrentQuery) {
        this.checkCurrentResourceTrigger();
        Extension queryCriteria = this.getOrCreateQueryCriteriaExtension();
        queryCriteria.addExtension(new Extension().setUrl("current").setValue((Type)new StringType(theCurrentQuery)));
        return this;
    }

    public R4SubscriptionTopicBuilder setResourceTriggerQueryCriteriaRequireBoth(boolean theRequireBoth) {
        this.checkCurrentResourceTrigger();
        Extension queryCriteria = this.getOrCreateQueryCriteriaExtension();
        queryCriteria.addExtension(new Extension().setUrl("requireBoth").setValue((Type)new BooleanType(theRequireBoth)));
        return this;
    }

    public R4SubscriptionTopicBuilder addCanFilterBy() {
        this.myCurrentCanFilterBy = new Extension().setUrl("http://hl7.org/fhir/4.3/StructureDefinition/extension-SubscriptionTopic.canFilterBy");
        this.myTopic.addExtension(this.myCurrentCanFilterBy);
        return this;
    }

    public R4SubscriptionTopicBuilder setCanFilterByDescription(String theDescription) {
        this.checkCurrentCanFilterBy();
        this.addNestedExtension(this.myCurrentCanFilterBy, "description", (Type)new MarkdownType(theDescription));
        return this;
    }

    public R4SubscriptionTopicBuilder setCanFilterByResource(String theResourceType) {
        this.checkCurrentCanFilterBy();
        this.addNestedExtension(this.myCurrentCanFilterBy, "resource", (Type)new UriType(theResourceType));
        return this;
    }

    public R4SubscriptionTopicBuilder setCanFilterByParameter(String theFilterParameter) {
        this.checkCurrentCanFilterBy();
        this.addNestedExtension(this.myCurrentCanFilterBy, "filterParameter", (Type)new StringType(theFilterParameter));
        return this;
    }

    public R4SubscriptionTopicBuilder addNotificationShape() {
        this.myCurrentNotificationShape = new Extension().setUrl("http://hl7.org/fhir/4.3/StructureDefinition/extension-SubscriptionTopic.notificationShape");
        this.myTopic.addExtension(this.myCurrentNotificationShape);
        return this;
    }

    public R4SubscriptionTopicBuilder setNotificationShapeResource(String theResourceType) {
        this.checkCurrentNotificationShape();
        this.addNestedExtension(this.myCurrentNotificationShape, "resource", (Type)new UriType(theResourceType));
        return this;
    }

    public R4SubscriptionTopicBuilder addNotificationShapeInclude(String theIncludeParam) {
        this.checkCurrentNotificationShape();
        this.addNestedExtension(this.myCurrentNotificationShape, "include", (Type)new StringType(theIncludeParam));
        return this;
    }

    public R4SubscriptionTopicBuilder addNotificationShapeRevInclude(String theRevIncludeParam) {
        this.checkCurrentNotificationShape();
        this.addNestedExtension(this.myCurrentNotificationShape, "revInclude", (Type)new StringType(theRevIncludeParam));
        return this;
    }

    public Basic build() {
        return this.myTopic;
    }

    private void checkCurrentResourceTrigger() {
        if (this.myCurrentResourceTrigger == null) {
            throw new IllegalStateException(Msg.code((int)2668) + "No current resource trigger defined. Call addResourceTrigger() first.");
        }
    }

    private void checkCurrentCanFilterBy() {
        if (this.myCurrentCanFilterBy == null) {
            throw new IllegalStateException(Msg.code((int)2669) + "No current can-filter-by defined. Call addCanFilterBy() first.");
        }
    }

    private void checkCurrentNotificationShape() {
        if (this.myCurrentNotificationShape == null) {
            throw new IllegalStateException(Msg.code((int)2670) + "No current notification shape defined. Call addNotificationShape() first.");
        }
    }

    private Extension getOrCreateQueryCriteriaExtension() {
        String queryExtensionUrl = "queryCriteria";
        return this.myCurrentResourceTrigger.getExtension().stream().filter(extension -> queryExtensionUrl.equals(extension.getUrl())).findFirst().orElseGet(() -> {
            Extension queryCriteria = new Extension().setUrl(queryExtensionUrl);
            this.myCurrentResourceTrigger.addExtension(queryCriteria);
            return queryCriteria;
        });
    }

    private void addExtension(String theUrl, Type theValue) {
        Extension extension = new Extension().setUrl(theUrl).setValue(theValue);
        this.myTopic.addExtension(extension);
    }

    private void addNestedExtension(Extension theParent, String theUrl, Type theValue) {
        Extension nestedExtension = new Extension().setUrl(theUrl).setValue(theValue);
        theParent.addExtension(nestedExtension);
    }
}

