/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.searchparam.matcher.SearchParamMatcher;
import ca.uhn.fhir.jpa.subscription.config.SubscriptionConfig;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.validator.SubscriptionQueryValidator;
import ca.uhn.fhir.jpa.topic.ISubscriptionTopicLoader;
import ca.uhn.fhir.jpa.topic.R4SubscriptionTopicLoader;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicLoader;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicMatchingListener;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicRegisteringListener;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicRegistry;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicSupport;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicValidatingInterceptor;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

@Configuration
@Import(value={SubscriptionConfig.class})
public class SubscriptionTopicConfig {
    @Bean
    public SubscriptionTopicMatchingListener subscriptionTopicMatchingSubscriber(FhirContext theFhirContext, MemoryCacheService memoryCacheService) {
        switch (theFhirContext.getVersion().getVersion()) {
            case R4: 
            case R5: 
            case R4B: {
                return new SubscriptionTopicMatchingListener(theFhirContext, memoryCacheService);
            }
        }
        return null;
    }

    @Bean
    @Lazy
    public SubscriptionTopicRegistry subscriptionTopicRegistry() {
        return new SubscriptionTopicRegistry();
    }

    @Bean
    @Lazy
    public SubscriptionTopicSupport subscriptionTopicSupport(FhirContext theFhirContext, DaoRegistry theDaoRegistry, SearchParamMatcher theSearchParamMatcher) {
        return new SubscriptionTopicSupport(theFhirContext, theDaoRegistry, theSearchParamMatcher);
    }

    @Bean
    public ISubscriptionTopicLoader subscriptionTopicLoader(FhirContext theFhirContext, SubscriptionTopicRegistry theSubscriptionTopicRegistry, ISearchParamRegistry theSearchParamRegistry) {
        VersionCanonicalizer versionCanonicalizer = new VersionCanonicalizer(theFhirContext);
        switch (theFhirContext.getVersion().getVersion()) {
            case R4: {
                return new R4SubscriptionTopicLoader(versionCanonicalizer, theSubscriptionTopicRegistry, theSearchParamRegistry);
            }
            case R5: 
            case R4B: {
                return new SubscriptionTopicLoader(versionCanonicalizer, theSubscriptionTopicRegistry, theSearchParamRegistry);
            }
        }
        return null;
    }

    @Bean
    public SubscriptionTopicRegisteringListener subscriptionTopicRegisteringSubscriber(FhirContext theFhirContext) {
        switch (theFhirContext.getVersion().getVersion()) {
            case R5: 
            case R4B: {
                return new SubscriptionTopicRegisteringListener();
            }
        }
        return null;
    }

    @Bean
    public SubscriptionTopicValidatingInterceptor subscriptionTopicValidatingInterceptor(FhirContext theFhirContext, SubscriptionQueryValidator theSubscriptionQueryValidator) {
        switch (theFhirContext.getVersion().getVersion()) {
            case R5: 
            case R4B: {
                return new SubscriptionTopicValidatingInterceptor(theFhirContext, theSubscriptionQueryValidator);
            }
        }
        return null;
    }
}

