/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicSupport;
import ca.uhn.fhir.jpa.topic.SubscriptionTriggerMatcher;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.SubscriptionTopic;

public class SubscriptionTopicMatcher {
    private final SubscriptionTopicSupport mySubscriptionTopicSupport;
    private final SubscriptionTopic myTopic;
    private final MemoryCacheService myMemoryCacheService;

    public SubscriptionTopicMatcher(SubscriptionTopicSupport theSubscriptionTopicSupport, SubscriptionTopic theTopic, MemoryCacheService memoryCacheService) {
        this.mySubscriptionTopicSupport = theSubscriptionTopicSupport;
        this.myTopic = theTopic;
        this.myMemoryCacheService = memoryCacheService;
    }

    public InMemoryMatchResult match(ResourceModifiedMessage theMsg) {
        IBaseResource resource = theMsg.getResource(this.mySubscriptionTopicSupport.getFhirContext());
        String resourceName = resource.fhirType();
        List triggers = this.myTopic.getResourceTrigger();
        for (SubscriptionTopic.SubscriptionTopicResourceTriggerComponent next : triggers) {
            SubscriptionTriggerMatcher matcher;
            InMemoryMatchResult result;
            if (!resourceName.equals(next.getResource()) || !(result = (matcher = new SubscriptionTriggerMatcher(this.mySubscriptionTopicSupport, theMsg, next, this.myMemoryCacheService)).match()).matched()) continue;
            return result;
        }
        return InMemoryMatchResult.noMatch();
    }
}

