/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.ResourceSearch;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicRegistry;
import ca.uhn.fhir.jpa.topic.status.INotificationStatusBuilder;
import ca.uhn.fhir.jpa.topic.status.R4BNotificationStatusBuilder;
import ca.uhn.fhir.jpa.topic.status.R4NotificationStatusBuilder;
import ca.uhn.fhir.jpa.topic.status.R5NotificationStatusBuilder;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.util.BundleBuilder;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionTopicPayloadBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionTopicPayloadBuilder.class);
    private static final int MAX_INCLUDES = 1000;
    private final FhirContext myFhirContext;
    private final FhirVersionEnum myFhirVersion;
    private final INotificationStatusBuilder<? extends IBaseResource> myNotificationStatusBuilder;
    private final DaoRegistry myDaoRegistry;
    private final SubscriptionTopicRegistry mySubscriptionTopicRegistry;
    private final MatchUrlService myMatchUrlService;

    public SubscriptionTopicPayloadBuilder(FhirContext theFhirContext, DaoRegistry theDaoRegistry, SubscriptionTopicRegistry theSubscriptionTopicRegistry, MatchUrlService theMatchUrlService) {
        this.myFhirContext = theFhirContext;
        this.myDaoRegistry = theDaoRegistry;
        this.mySubscriptionTopicRegistry = theSubscriptionTopicRegistry;
        this.myMatchUrlService = theMatchUrlService;
        this.myFhirVersion = this.myFhirContext.getVersion().getVersion();
        switch (this.myFhirVersion) {
            case R4: {
                this.myNotificationStatusBuilder = new R4NotificationStatusBuilder(this.myFhirContext);
                break;
            }
            case R4B: {
                this.myNotificationStatusBuilder = new R4BNotificationStatusBuilder(this.myFhirContext);
                break;
            }
            case R5: {
                this.myNotificationStatusBuilder = new R5NotificationStatusBuilder(this.myFhirContext);
                break;
            }
            default: {
                throw this.unsupportedFhirVersionException();
            }
        }
    }

    public IBaseBundle buildPayload(List<IBaseResource> theResources, ActiveSubscription theActiveSubscription, String theTopicUrl, RestOperationTypeEnum theRestOperationType) {
        BundleBuilder bundleBuilder = new BundleBuilder(this.myFhirContext);
        IBaseResource notificationStatus = this.myNotificationStatusBuilder.buildNotificationStatus(theResources, theActiveSubscription, theTopicUrl);
        bundleBuilder.addCollectionEntry(notificationStatus);
        this.addResources(theResources, theActiveSubscription.getSubscription(), theRestOperationType, bundleBuilder);
        Set<IBaseResource> notificationShapeResources = this.getNotificationShapeResources(theResources, theTopicUrl);
        for (IBaseResource resource : notificationShapeResources) {
            bundleBuilder.addCollectionEntry(resource);
        }
        this.setBundleType(bundleBuilder);
        IBaseBundle retval = bundleBuilder.getBundle();
        if (ourLog.isDebugEnabled()) {
            String bundle = this.myFhirContext.newJsonParser().setPrettyPrint(true).encodeResourceToString((IBaseResource)retval);
            ourLog.debug("Bundle: {}", (Object)bundle);
        }
        return retval;
    }

    private Set<IBaseResource> getNotificationShapeResources(List<IBaseResource> theResources, String theTopicUrl) {
        HashSet<IBaseResource> resultResources = new HashSet<IBaseResource>();
        if (theResources.isEmpty() || this.mySubscriptionTopicRegistry == null) {
            return Set.of();
        }
        Optional<SubscriptionTopic> oTopic = this.mySubscriptionTopicRegistry.findSubscriptionTopicByUrl(theTopicUrl);
        if (oTopic.isEmpty()) {
            ourLog.warn("No subscription topic found for URL: {}", (Object)theTopicUrl);
            return Set.of();
        }
        SubscriptionTopic topic = oTopic.get();
        for (SubscriptionTopic.SubscriptionTopicNotificationShapeComponent shape : topic.getNotificationShape()) {
            String resourceType = shape.getResource();
            if (resourceType == null) {
                ourLog.warn("Notification Shape on SubscriptionTopic/{} (with url {}) is missing mandatory resource.", (Object)topic.getId(), (Object)topic.getUrl());
                continue;
            }
            List<IBaseResource> resourcesOfThisType = theResources.stream().filter(r -> this.myFhirContext.getResourceType(r).equals(resourceType)).collect(Collectors.toList());
            if (resourcesOfThisType.isEmpty()) continue;
            List include = shape.getInclude();
            List revInclude = shape.getRevInclude();
            Set<IBaseResource> includedResources = this.getIncludedResources(resourceType, resourcesOfThisType, include, revInclude);
            resultResources.addAll(includedResources);
        }
        return resultResources;
    }

    private Set<IBaseResource> getIncludedResources(String theResourceType, List<IBaseResource> theResourcesOfThisType, List<StringType> theIncludes, List<StringType> theRevIncludes) {
        HashSet<IBaseResource> resultResources = new HashSet<IBaseResource>();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResourceType);
        for (IBaseResource resource : theResourcesOfThisType) {
            StringBuilder query = new StringBuilder(theResourceType + "?_id=" + resource.getIdElement().getIdPart());
            for (StringType include : theIncludes) {
                query.append("&_include=").append(ParameterUtil.escapeAndUrlEncode((String)((String)include.getValue())));
            }
            for (StringType revInclude : theRevIncludes) {
                query.append("&_revinclude=").append(ParameterUtil.escapeAndUrlEncode((String)((String)revInclude.getValue())));
            }
            ResourceSearch resourceSearch = this.myMatchUrlService.getResourceSearchWithIncludesAndRevIncludes(query.toString());
            SearchParameterMap map = resourceSearch.getSearchParameterMap();
            map.setLoadSynchronousUpTo(Integer.valueOf(1000));
            SystemRequestDetails systemRequestDetails = SubscriptionTopicPayloadBuilder.buildSystemRequestDetails(resource);
            IBundleProvider result = dao.search(map, (RequestDetails)systemRequestDetails);
            Integer size = result.size();
            if (size != null && size >= 1000) {
                ourLog.warn("More than {} include/revincluded resources found. Number of include/revincluded resources limited to {}", (Object)1000, (Object)1000);
            }
            result.getAllResources().stream().filter(r -> !r.getIdElement().toUnqualifiedVersionless().equals(resource.getIdElement().toUnqualifiedVersionless())).forEach(resultResources::add);
        }
        return resultResources;
    }

    @Nonnull
    private static SystemRequestDetails buildSystemRequestDetails(IBaseResource resource) {
        SystemRequestDetails systemRequestDetails = new SystemRequestDetails();
        RequestPartitionId requestPartitionId = (RequestPartitionId)resource.getUserData(Constants.RESOURCE_PARTITION_ID);
        if (requestPartitionId == null) {
            systemRequestDetails.setRequestPartitionId(RequestPartitionId.allPartitions());
        } else {
            systemRequestDetails.setRequestPartitionId(requestPartitionId);
        }
        return systemRequestDetails;
    }

    private void addResources(List<IBaseResource> theResources, CanonicalSubscription theCanonicalSubscription, RestOperationTypeEnum theRestOperationType, BundleBuilder theBundleBuilder) {
        Subscription.SubscriptionPayloadContent content = (Subscription.SubscriptionPayloadContent)ObjectUtils.defaultIfNull((Object)theCanonicalSubscription.getContent(), (Object)Subscription.SubscriptionPayloadContent.FULLRESOURCE);
        switch (content) {
            case IDONLY: {
                this.addIdOnly(theBundleBuilder, theResources, theRestOperationType);
                break;
            }
            case FULLRESOURCE: {
                this.addFullResources(theBundleBuilder, theResources, theRestOperationType);
                break;
            }
        }
    }

    private void addIdOnly(BundleBuilder bundleBuilder, List<IBaseResource> theResources, RestOperationTypeEnum theRestOperationType) {
        for (IBaseResource resource : theResources) {
            switch (theRestOperationType) {
                case CREATE: {
                    bundleBuilder.addTransactionCreateEntryIdOnly(resource);
                    break;
                }
                case UPDATE: {
                    bundleBuilder.addTransactionUpdateIdOnlyEntry(resource);
                    break;
                }
                case DELETE: {
                    bundleBuilder.addTransactionDeleteEntry(resource);
                    break;
                }
            }
        }
    }

    private void addFullResources(BundleBuilder bundleBuilder, List<IBaseResource> theResources, RestOperationTypeEnum theRestOperationType) {
        for (IBaseResource resource : theResources) {
            switch (theRestOperationType) {
                case CREATE: {
                    bundleBuilder.addTransactionCreateEntry(resource);
                    break;
                }
                case UPDATE: {
                    bundleBuilder.addTransactionUpdateEntry(resource);
                    break;
                }
                case DELETE: {
                    bundleBuilder.addTransactionDeleteEntry(resource);
                    break;
                }
            }
        }
    }

    private void setBundleType(BundleBuilder bundleBuilder) {
        switch (this.myFhirVersion) {
            case R4: 
            case R4B: {
                bundleBuilder.setType(Bundle.BundleType.HISTORY.toCode());
                break;
            }
            case R5: {
                bundleBuilder.setType(Bundle.BundleType.SUBSCRIPTIONNOTIFICATION.toCode());
                break;
            }
            default: {
                throw this.unsupportedFhirVersionException();
            }
        }
    }

    private IllegalStateException unsupportedFhirVersionException() {
        return new IllegalStateException(Msg.code((int)2331) + "SubscriptionTopic subscriptions are not supported on FHIR version: " + String.valueOf(this.myFhirVersion));
    }
}

