/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic.status;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicUtil;
import ca.uhn.fhir.jpa.topic.status.INotificationStatusBuilder;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.SubscriptionStatus;

public class R5NotificationStatusBuilder
implements INotificationStatusBuilder<SubscriptionStatus> {
    private final FhirContext myFhirContext;

    public R5NotificationStatusBuilder(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    @Override
    public SubscriptionStatus buildNotificationStatus(List<IBaseResource> theResources, ActiveSubscription theActiveSubscription, String theTopicUrl) {
        long eventNumber = theActiveSubscription.getDeliveriesCount();
        CanonicalSubscription canonicalSubscription = theActiveSubscription.getSubscription();
        SubscriptionStatus subscriptionStatus = new SubscriptionStatus();
        subscriptionStatus.setId(UUID.randomUUID().toString());
        subscriptionStatus.setStatus(Enumerations.SubscriptionStatusCodes.ACTIVE);
        subscriptionStatus.setType(SubscriptionStatus.SubscriptionNotificationType.EVENTNOTIFICATION);
        subscriptionStatus.setEventsSinceSubscriptionStart(eventNumber);
        SubscriptionStatus.SubscriptionStatusNotificationEventComponent event = subscriptionStatus.addNotificationEvent();
        event.setEventNumber(eventNumber);
        if (!theResources.isEmpty() && !SubscriptionTopicUtil.isEmptyContentTopicSubscription(canonicalSubscription)) {
            event.setFocus(new Reference(theResources.get(0).getIdElement()));
        }
        subscriptionStatus.setSubscription(new Reference(theActiveSubscription.getSubscription().getIdElement(this.myFhirContext)));
        subscriptionStatus.setTopic(theTopicUrl);
        return subscriptionStatus;
    }
}

