/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.controller;

import ca.uhn.hapi.fhir.cdshooks.api.ICdsServiceRegistry;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceFeedbackJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServicesJson;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cds-services"})
public class CdsHooksController {
    static final String BASE = "/cds-services";
    private final ICdsServiceRegistry myCdsServiceRegistry;

    public CdsHooksController(ICdsServiceRegistry theCdsServiceRegistry) {
        this.myCdsServiceRegistry = theCdsServiceRegistry;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(path={""}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<CdsServicesJson> cdsServices() {
        CdsServicesJson response = this.myCdsServiceRegistry.getCdsServicesJson();
        return ResponseEntity.status((int)200).contentType(MediaType.APPLICATION_JSON).body((Object)response);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(path={"{cds_hook}"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResponseEntity<CdsServiceResponseJson> cdsServiceRequest(@PathVariable(value="cds_hook") String theCdsHook, @RequestBody CdsServiceRequestJson theCdsServiceRequestJson) {
        CdsServiceResponseJson response = this.myCdsServiceRegistry.callService(theCdsHook, theCdsServiceRequestJson);
        return ResponseEntity.status((int)200).contentType(MediaType.APPLICATION_JSON).body((Object)response);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(path={"{cds_hook}/feedback"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResponseEntity<CdsServiceFeedbackJson> cdsServiceFeedback(@PathVariable(value="cds_hook") String theCdsHook, @RequestBody CdsServiceFeedbackJson theCdsServiceFeedbackJson) {
        CdsServiceFeedbackJson response = this.myCdsServiceRegistry.callFeedback(theCdsHook, theCdsServiceFeedbackJson);
        return ResponseEntity.status((int)200).contentType(MediaType.APPLICATION_JSON).body((Object)response);
    }
}

