/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.serializer;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.serializer.FhirResourceDeserializer;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsHooksExtension;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestContextJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestJson;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsServiceRegistryImpl;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class CdsServiceRequestJsonDeserializer
extends StdDeserializer<CdsServiceRequestJson> {
    private final CdsServiceRegistryImpl myCdsServiceRegistry;
    private final ObjectMapper myObjectMapper;
    private final FhirContext myFhirContext;
    private final IParser myParser;

    public CdsServiceRequestJsonDeserializer(CdsServiceRegistryImpl theCdsServiceRegistry, FhirContext theFhirContext) {
        super(CdsServiceRequestJson.class);
        this.myCdsServiceRegistry = theCdsServiceRegistry;
        this.myFhirContext = theFhirContext;
        this.myParser = this.myFhirContext.newJsonParser().setPrettyPrint(true);
        this.myObjectMapper = new ObjectMapper();
        this.configureObjectMapper(this.myObjectMapper);
    }

    public CdsServiceRequestJson deserialize(JsonParser theJsonParser, DeserializationContext theDeserializationContext) throws IOException {
        JsonNode cdsServiceRequestJsonNode = (JsonNode)theJsonParser.getCodec().readTree(theJsonParser);
        JsonNode hookNode = cdsServiceRequestJsonNode.get("hook");
        JsonNode extensionNode = cdsServiceRequestJsonNode.get("extension");
        JsonNode requestContext = cdsServiceRequestJsonNode.get("context");
        CdsServiceRequestJson cdsServiceRequestJson = (CdsServiceRequestJson)this.myObjectMapper.treeToValue((TreeNode)cdsServiceRequestJsonNode, CdsServiceRequestJson.class);
        if (extensionNode != null) {
            CdsHooksExtension myRequestExtension = this.deserializeExtension(hookNode.textValue(), extensionNode.toString());
            cdsServiceRequestJson.setExtension(myRequestExtension);
        }
        if (requestContext != null) {
            LinkedHashMap map = (LinkedHashMap)this.myObjectMapper.readValue(requestContext.toString(), LinkedHashMap.class);
            cdsServiceRequestJson.setContext(this.deserializeRequestContext(map));
        }
        return cdsServiceRequestJson;
    }

    void configureObjectMapper(ObjectMapper theObjectMapper) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(IBaseResource.class, (JsonDeserializer)new FhirResourceDeserializer(this.myFhirContext));
        theObjectMapper.registerModule((Module)module);
        theObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    CdsHooksExtension deserializeExtension(String theServiceId, String theExtension) throws JsonProcessingException {
        CdsServiceJson cdsServicesJson = this.myCdsServiceRegistry.getCdsServiceJson(theServiceId);
        Class<? extends CdsHooksExtension> extensionClass = cdsServicesJson.getExtensionClass();
        if (extensionClass == null) {
            return null;
        }
        return (CdsHooksExtension)this.myObjectMapper.readValue(theExtension, extensionClass);
    }

    CdsServiceRequestContextJson deserializeRequestContext(LinkedHashMap<String, Object> theMap) throws JsonProcessingException {
        CdsServiceRequestContextJson cdsServiceRequestContextJson = new CdsServiceRequestContextJson();
        for (Map.Entry<String, Object> entry : theMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof LinkedHashMap) {
                String json = this.myObjectMapper.writeValueAsString(value);
                IBaseResource resource = this.myParser.parseResource(json);
                cdsServiceRequestContextJson.put(key, resource);
                continue;
            }
            cdsServiceRequestContextJson.put(key, value);
        }
        return cdsServiceRequestContextJson;
    }
}

