/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsMethod;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

abstract class BaseCdsMethod
implements ICdsMethod {
    private final Object myServiceBean;
    private final Method myMethod;

    BaseCdsMethod(Object theServiceBean, Method theMethod) {
        this.myServiceBean = theServiceBean;
        this.myMethod = theMethod;
    }

    @Override
    public Object invoke(ObjectMapper theObjectMapper, IModelJson theJson, String theServiceId) {
        try {
            if (this.parameterIsString()) {
                String json = this.encodeRequest(theObjectMapper, theJson, theServiceId);
                return this.myMethod.invoke(this.myServiceBean, json);
            }
            return this.myMethod.invoke(this.myServiceBean, theJson);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e.getCause() != null && e.getCause() instanceof BaseServerResponseException) {
                throw (BaseServerResponseException)e.getCause();
            }
            throw new ConfigurationException(Msg.code((int)2376) + "Failed to invoke " + this.myMethod.getName() + " method on " + this.myServiceBean.getClass().getName(), (Throwable)e);
        }
    }

    private boolean parameterIsString() {
        return String.class.isAssignableFrom(this.myMethod.getParameterTypes()[0]);
    }

    private String encodeRequest(ObjectMapper theObjectMapper, IModelJson theCdsServiceRequestJson, String theServiceId) {
        try {
            return theObjectMapper.writeValueAsString((Object)theCdsServiceRequestJson);
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException(Msg.code((int)2377) + "Failed to deserialize CDS Hooks service request json instance when calling CDS Hooks Service " + theServiceId, (Throwable)e);
        }
    }
}

