/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.cr;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.CdsCrServiceDstu3;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.CdsCrServiceR4;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.CdsCrServiceR5;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.ICdsCrService;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.ICdsCrServiceRegistry;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CdsCrServiceRegistry
implements ICdsCrServiceRegistry {
    private final Map<FhirVersionEnum, Class<? extends ICdsCrService>> myCdsCrServices = new HashMap<FhirVersionEnum, Class<? extends ICdsCrService>>();

    public CdsCrServiceRegistry() {
        this.myCdsCrServices.put(FhirVersionEnum.DSTU3, CdsCrServiceDstu3.class);
        this.myCdsCrServices.put(FhirVersionEnum.R4, CdsCrServiceR4.class);
        this.myCdsCrServices.put(FhirVersionEnum.R5, CdsCrServiceR5.class);
    }

    @Override
    public void register(@Nonnull FhirVersionEnum theFhirVersion, @Nonnull Class<? extends ICdsCrService> theCdsCrService) {
        this.myCdsCrServices.put(theFhirVersion, theCdsCrService);
    }

    @Override
    public void unregister(@Nonnull FhirVersionEnum theFhirVersion) {
        this.myCdsCrServices.remove(theFhirVersion);
    }

    @Override
    public Optional<Class<? extends ICdsCrService>> find(@Nonnull FhirVersionEnum theFhirVersion) {
        return Optional.ofNullable(this.myCdsCrServices.get(theFhirVersion));
    }
}

