/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.cr;

import ca.uhn.fhir.jpa.cache.IResourceChangeEvent;
import ca.uhn.fhir.jpa.cache.IResourceChangeListener;
import ca.uhn.fhir.jpa.cache.ResourceChangeEvent;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsServiceRegistryImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CdsServiceInterceptor
implements IResourceChangeListener {
    static final Logger ourLog = LoggerFactory.getLogger(CdsServiceInterceptor.class);
    @Autowired
    CdsServiceRegistryImpl myCdsServiceRegistry;

    public void handleInit(Collection<IIdType> theResourceIds) {
        this.handleChange((IResourceChangeEvent)ResourceChangeEvent.fromCreatedUpdatedDeletedResourceIds(new ArrayList<IIdType>(theResourceIds), Collections.emptyList(), Collections.emptyList()));
    }

    public void handleChange(IResourceChangeEvent theResourceChangeEvent) {
        if (theResourceChangeEvent == null) {
            return;
        }
        if (theResourceChangeEvent.getCreatedResourceIds() != null && !theResourceChangeEvent.getCreatedResourceIds().isEmpty()) {
            this.insert(theResourceChangeEvent.getCreatedResourceIds());
        }
        if (theResourceChangeEvent.getUpdatedResourceIds() != null && !theResourceChangeEvent.getUpdatedResourceIds().isEmpty()) {
            this.update(theResourceChangeEvent.getUpdatedResourceIds());
        }
        if (theResourceChangeEvent.getDeletedResourceIds() != null && !theResourceChangeEvent.getDeletedResourceIds().isEmpty()) {
            this.delete(theResourceChangeEvent.getDeletedResourceIds());
        }
    }

    private void insert(List<IIdType> theCreatedIds) {
        for (IIdType id : theCreatedIds) {
            try {
                this.myCdsServiceRegistry.registerCrService(id.getIdPart());
            }
            catch (Exception e) {
                ourLog.info(String.format("Failed to create service for %s", id.getIdPart()));
            }
        }
    }

    private void update(List<IIdType> updatedIds) {
        try {
            this.delete(updatedIds);
            this.insert(updatedIds);
        }
        catch (Exception e) {
            ourLog.info(String.format("Failed to update service(s) for %s", updatedIds));
        }
    }

    private void delete(List<IIdType> deletedIds) {
        for (IIdType id : deletedIds) {
            this.myCdsServiceRegistry.unregisterService(id.getIdPart(), "CR");
        }
    }
}

