/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery.CrDiscoveryServiceDstu3;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery.CrDiscoveryServiceR4;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery.CrDiscoveryServiceR5;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery.ICdsCrDiscoveryServiceRegistry;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery.ICrDiscoveryService;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CdsCrDiscoveryServiceRegistry
implements ICdsCrDiscoveryServiceRegistry {
    private final Map<FhirVersionEnum, Class<? extends ICrDiscoveryService>> myCrDiscoveryServices = new HashMap<FhirVersionEnum, Class<? extends ICrDiscoveryService>>();

    public CdsCrDiscoveryServiceRegistry() {
        this.myCrDiscoveryServices.put(FhirVersionEnum.DSTU3, CrDiscoveryServiceDstu3.class);
        this.myCrDiscoveryServices.put(FhirVersionEnum.R4, CrDiscoveryServiceR4.class);
        this.myCrDiscoveryServices.put(FhirVersionEnum.R5, CrDiscoveryServiceR5.class);
    }

    @Override
    public void register(@Nonnull FhirVersionEnum theFhirVersion, @Nonnull Class<? extends ICrDiscoveryService> theCrDiscoveryService) {
        this.myCrDiscoveryServices.put(theFhirVersion, theCrDiscoveryService);
    }

    @Override
    public void unregister(@Nonnull FhirVersionEnum theFhirVersion) {
        this.myCrDiscoveryServices.remove(theFhirVersion);
    }

    @Override
    public Optional<Class<? extends ICrDiscoveryService>> find(@Nonnull FhirVersionEnum theFhirVersion) {
        return Optional.ofNullable(this.myCrDiscoveryServices.get(theFhirVersion));
    }
}

