/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceJson;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.CdsCrUtils;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery.CrDiscoveryElementR5;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery.ICrDiscoveryService;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery.PrefetchUrlList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.r5.SearchHelper;

public class CrDiscoveryServiceR5
implements ICrDiscoveryService {
    protected final String PATIENT_ID_CONTEXT = "{{context.patientId}}";
    protected final int DEFAULT_MAX_URI_LENGTH = 8000;
    protected int myMaxUriLength;
    protected final Repository myRepository;
    protected final IIdType myPlanDefinitionId;

    public CrDiscoveryServiceR5(IIdType thePlanDefinitionId, Repository theRepository) {
        this.myPlanDefinitionId = thePlanDefinitionId;
        this.myRepository = theRepository;
        this.myMaxUriLength = 8000;
    }

    @Override
    public CdsServiceJson resolveService() {
        return this.resolveService(CdsCrUtils.readPlanDefinitionFromRepository(FhirVersionEnum.R5, this.myRepository, this.myPlanDefinitionId));
    }

    protected CdsServiceJson resolveService(IBaseResource thePlanDefinition) {
        if (thePlanDefinition instanceof PlanDefinition) {
            PlanDefinition planDef = (PlanDefinition)thePlanDefinition;
            return new CrDiscoveryElementR5(planDef, this.getPrefetchUrlList(planDef)).getCdsServiceJson();
        }
        return null;
    }

    public boolean isEca(PlanDefinition thePlanDefinition) {
        if (thePlanDefinition.hasType() && thePlanDefinition.getType().hasCoding()) {
            for (Coding coding : thePlanDefinition.getType().getCoding()) {
                if (!coding.getCode().equals("eca-rule")) continue;
                return true;
            }
        }
        return false;
    }

    public Library resolvePrimaryLibrary(PlanDefinition thePlanDefinition) {
        Library library = null;
        if (thePlanDefinition.hasLibrary() && !thePlanDefinition.getLibrary().isEmpty()) {
            library = (Library)SearchHelper.searchRepositoryByCanonical((Repository)this.myRepository, (IPrimitiveType)((CanonicalType)thePlanDefinition.getLibrary().get(0)));
        }
        return library;
    }

    public List<String> resolveValueCodingCodes(List<Coding> theValueCodings) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder codes = new StringBuilder();
        for (Coding coding : theValueCodings) {
            if (!coding.hasCode()) continue;
            String system = coding.getSystem();
            String code = coding.getCode();
            codes = this.getCodesStringBuilder(result, codes, system, code);
        }
        result.add(codes.toString());
        return result;
    }

    public List<String> resolveValueSetCodes(CanonicalType theValueSetId) {
        ValueSet valueSet = (ValueSet)SearchHelper.searchRepositoryByCanonical((Repository)this.myRepository, (IPrimitiveType)theValueSetId);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder codes = new StringBuilder();
        if (valueSet.hasExpansion() && valueSet.getExpansion().hasContains()) {
            for (ValueSet.ValueSetExpansionContainsComponent contains : valueSet.getExpansion().getContains()) {
                String system = contains.getSystem();
                String code = contains.getCode();
                codes = this.getCodesStringBuilder(result, codes, system, code);
            }
        } else if (valueSet.hasCompose() && valueSet.getCompose().hasInclude()) {
            for (ValueSet.ConceptSetComponent concepts : valueSet.getCompose().getInclude()) {
                String system = concepts.getSystem();
                if (!concepts.hasConcept()) continue;
                for (ValueSet.ConceptReferenceComponent concept : concepts.getConcept()) {
                    String code = concept.getCode();
                    codes = this.getCodesStringBuilder(result, codes, system, code);
                }
            }
        }
        result.add(codes.toString());
        return result;
    }

    protected StringBuilder getCodesStringBuilder(List<String> theList, StringBuilder theCodes, String theSystem, String theCode) {
        String codeToken = theSystem + "|" + theCode;
        int postAppendLength = theCodes.length() + codeToken.length();
        if (theCodes.length() > 0 && postAppendLength < this.myMaxUriLength) {
            theCodes.append(",");
        } else if (postAppendLength > this.myMaxUriLength) {
            theList.add(theCodes.toString());
            theCodes = new StringBuilder();
        }
        theCodes.append(codeToken);
        return theCodes;
    }

    public List<String> createRequestUrl(DataRequirement theDataRequirement) {
        if (!CrDiscoveryServiceR5.isPatientCompartment(theDataRequirement.getType().toCode())) {
            return null;
        }
        String patientRelatedResource = theDataRequirement.getType() + "?" + this.getPatientSearchParam(theDataRequirement.getType().toCode()) + "=Patient/{{context.patientId}}";
        ArrayList<String> ret = new ArrayList<String>();
        if (theDataRequirement.hasCodeFilter()) {
            for (DataRequirement.DataRequirementCodeFilterComponent codeFilterComponent : theDataRequirement.getCodeFilter()) {
                if (!codeFilterComponent.hasPath()) continue;
                String path = this.mapCodePathToSearchParam(theDataRequirement.getType().toCode(), codeFilterComponent.getPath());
                if (codeFilterComponent.hasValueSetElement()) {
                    for (String codes : this.resolveValueSetCodes(codeFilterComponent.getValueSetElement())) {
                        ret.add(patientRelatedResource + "&" + path + "=" + codes);
                    }
                    continue;
                }
                if (!codeFilterComponent.hasCode()) continue;
                List codeFilterValueCodings = codeFilterComponent.getCode();
                boolean isFirstCodingInFilter = true;
                for (String code : this.resolveValueCodingCodes(codeFilterValueCodings)) {
                    if (isFirstCodingInFilter) {
                        ret.add(patientRelatedResource + "&" + path + "=" + code);
                    } else {
                        ret.add("," + code);
                    }
                    isFirstCodingInFilter = false;
                }
            }
            return ret;
        }
        ret.add(patientRelatedResource);
        return ret;
    }

    public PrefetchUrlList getPrefetchUrlList(PlanDefinition thePlanDefinition) {
        PrefetchUrlList prefetchList = new PrefetchUrlList();
        if (thePlanDefinition == null) {
            return null;
        }
        if (!this.isEca(thePlanDefinition)) {
            return null;
        }
        Library library = this.resolvePrimaryLibrary(thePlanDefinition);
        if (library == null || !library.hasDataRequirement()) {
            return null;
        }
        for (DataRequirement dataRequirement : library.getDataRequirement()) {
            List<String> requestUrls = this.createRequestUrl(dataRequirement);
            if (requestUrls == null) continue;
            prefetchList.addAll((Collection<? extends String>)requestUrls);
        }
        return prefetchList;
    }

    protected String mapCodePathToSearchParam(String theDataType, String thePath) {
        switch (theDataType) {
            case "MedicationAdministration": {
                if (!thePath.equals("medication")) break;
                return "code";
            }
            case "MedicationDispense": {
                if (!thePath.equals("medication")) break;
                return "code";
            }
            case "MedicationRequest": {
                if (!thePath.equals("medication")) break;
                return "code";
            }
            case "MedicationStatement": {
                if (!thePath.equals("medication")) break;
                return "code";
            }
            default: {
                if (!thePath.equals("vaccineCode")) break;
                return "vaccine-code";
            }
        }
        return thePath.replace('.', '-').toLowerCase();
    }

    public static boolean isPatientCompartment(String theDataType) {
        if (theDataType == null) {
            return false;
        }
        switch (theDataType) {
            case "Account": 
            case "AdverseEvent": 
            case "AllergyIntolerance": 
            case "Appointment": 
            case "AppointmentResponse": 
            case "AuditEvent": 
            case "Basic": 
            case "BodyStructure": 
            case "CarePlan": 
            case "CareTeam": 
            case "ChargeItem": 
            case "Claim": 
            case "ClaimResponse": 
            case "ClinicalImpression": 
            case "Communication": 
            case "CommunicationRequest": 
            case "Composition": 
            case "Condition": 
            case "Consent": 
            case "Coverage": 
            case "CoverageEligibilityRequest": 
            case "CoverageEligibilityResponse": 
            case "DetectedIssue": 
            case "DeviceRequest": 
            case "DeviceUseStatement": 
            case "DiagnosticReport": 
            case "DocumentManifest": 
            case "DocumentReference": 
            case "Encounter": 
            case "EnrollmentRequest": 
            case "EpisodeOfCare": 
            case "ExplanationOfBenefit": 
            case "FamilyMemberHistory": 
            case "Flag": 
            case "Goal": 
            case "Group": 
            case "ImagingStudy": 
            case "Immunization": 
            case "ImmunizationEvaluation": 
            case "ImmunizationRecommendation": 
            case "Invoice": 
            case "List": 
            case "MeasureReport": 
            case "Media": 
            case "MedicationAdministration": 
            case "MedicationDispense": 
            case "MedicationRequest": 
            case "MedicationStatement": 
            case "MolecularSequence": 
            case "NutritionOrder": 
            case "Observation": 
            case "Patient": 
            case "Person": 
            case "Procedure": 
            case "Provenance": 
            case "QuestionnaireResponse": 
            case "RelatedPerson": 
            case "RequestGroup": 
            case "ResearchSubject": 
            case "RiskAssessment": 
            case "Schedule": 
            case "ServiceRequest": 
            case "Specimen": 
            case "SupplyDelivery": 
            case "SupplyRequest": 
            case "VisionPrescription": {
                return true;
            }
        }
        return false;
    }

    public String getPatientSearchParam(String theDataType) {
        switch (theDataType) {
            case "Account": {
                return "subject";
            }
            case "AdverseEvent": {
                return "subject";
            }
            case "AllergyIntolerance": {
                return "patient";
            }
            case "Appointment": {
                return "actor";
            }
            case "AppointmentResponse": {
                return "actor";
            }
            case "AuditEvent": {
                return "patient";
            }
            case "Basic": {
                return "patient";
            }
            case "BodyStructure": {
                return "patient";
            }
            case "CarePlan": {
                return "patient";
            }
            case "CareTeam": {
                return "patient";
            }
            case "ChargeItem": {
                return "subject";
            }
            case "Claim": {
                return "patient";
            }
            case "ClaimResponse": {
                return "patient";
            }
            case "ClinicalImpression": {
                return "subject";
            }
            case "Communication": {
                return "subject";
            }
            case "CommunicationRequest": {
                return "subject";
            }
            case "Composition": {
                return "subject";
            }
            case "Condition": {
                return "patient";
            }
            case "Consent": {
                return "patient";
            }
            case "Coverage": {
                return "policy-holder";
            }
            case "DetectedIssue": {
                return "patient";
            }
            case "DeviceRequest": {
                return "subject";
            }
            case "DeviceUseStatement": {
                return "subject";
            }
            case "DiagnosticReport": {
                return "subject";
            }
            case "DocumentManifest": {
                return "subject";
            }
            case "DocumentReference": {
                return "subject";
            }
            case "Encounter": {
                return "patient";
            }
            case "EnrollmentRequest": {
                return "subject";
            }
            case "EpisodeOfCare": {
                return "patient";
            }
            case "ExplanationOfBenefit": {
                return "patient";
            }
            case "FamilyMemberHistory": {
                return "patient";
            }
            case "Flag": {
                return "patient";
            }
            case "Goal": {
                return "patient";
            }
            case "Group": {
                return "member";
            }
            case "ImagingStudy": {
                return "patient";
            }
            case "Immunization": {
                return "patient";
            }
            case "ImmunizationRecommendation": {
                return "patient";
            }
            case "Invoice": {
                return "subject";
            }
            case "List": {
                return "subject";
            }
            case "MeasureReport": {
                return "patient";
            }
            case "Media": {
                return "subject";
            }
            case "MedicationAdministration": {
                return "patient";
            }
            case "MedicationDispense": {
                return "patient";
            }
            case "MedicationRequest": {
                return "subject";
            }
            case "MedicationStatement": {
                return "subject";
            }
            case "MolecularSequence": {
                return "patient";
            }
            case "NutritionOrder": {
                return "patient";
            }
            case "Observation": {
                return "subject";
            }
            case "Patient": {
                return "_id";
            }
            case "Person": {
                return "patient";
            }
            case "Procedure": {
                return "patient";
            }
            case "Provenance": {
                return "patient";
            }
            case "QuestionnaireResponse": {
                return "subject";
            }
            case "RelatedPerson": {
                return "patient";
            }
            case "RequestGroup": {
                return "subject";
            }
            case "ResearchSubject": {
                return "individual";
            }
            case "RiskAssessment": {
                return "subject";
            }
            case "Schedule": {
                return "actor";
            }
            case "ServiceRequest": {
                return "patient";
            }
            case "Specimen": {
                return "subject";
            }
            case "SupplyDelivery": {
                return "patient";
            }
            case "SupplyRequest": {
                return "subject";
            }
            case "VisionPrescription": {
                return "patient";
            }
        }
        return null;
    }
}

