/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.prefetch;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.interceptor.BearerTokenAuthInterceptor;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestAuthorizationJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestJson;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.stereotype.Service;

@Service
public class CdsPrefetchFhirClientSvc {
    private final FhirContext myFhirContext;

    public CdsPrefetchFhirClientSvc(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    public IBaseResource resourceFromUrl(CdsServiceRequestJson theCdsServiceRequestJson, String theUrl) {
        IGenericClient client = this.buildClient(theCdsServiceRequestJson);
        UrlUtil.UrlParts parts = UrlUtil.parseUrl((String)theUrl);
        String resourceType = parts.getResourceType();
        if (StringUtils.isEmpty((CharSequence)resourceType)) {
            throw new InvalidRequestException(Msg.code((int)2383) + "Failed to resolve " + theUrl + ". Url does not start with a resource type.");
        }
        String resourceId = parts.getResourceId();
        String matchUrl = parts.getParams();
        if (resourceId != null) {
            return (IBaseResource)client.read().resource(resourceType).withId(resourceId).execute();
        }
        if (matchUrl != null) {
            return (IBaseResource)client.search().byUrl(theUrl).execute();
        }
        throw new InvalidRequestException(Msg.code((int)2384) + "Unable to translate url " + theUrl + " into a resource or a bundle.");
    }

    private IGenericClient buildClient(CdsServiceRequestJson theCdsServiceRequestJson) {
        String fhirServerBase = theCdsServiceRequestJson.getFhirServer();
        CdsServiceRequestAuthorizationJson serviceRequestAuthorization = theCdsServiceRequestJson.getServiceRequestAuthorizationJson();
        IGenericClient client = this.myFhirContext.newRestfulGenericClient(fhirServerBase);
        if (serviceRequestAuthorization != null && serviceRequestAuthorization.getAccessToken() != null) {
            BearerTokenAuthInterceptor authInterceptor = new BearerTokenAuthInterceptor(serviceRequestAuthorization.getAccessToken());
            client.registerInterceptor((Object)authInterceptor);
        }
        return client;
    }
}

