/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.prefetch;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestContextJson;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;

public class PrefetchTemplateUtil {
    private static final Pattern ourPlaceholder = Pattern.compile("\\{\\{context\\.(\\w+)}}");
    private static final Pattern daVinciPreFetch = Pattern.compile("\\{\\{context\\.(\\w+)\\.(\\w+)\\.(id)}}");
    private static final int GROUP_WITH_KEY = 1;
    private static final int DAVINCI_RESOURCETYPE_KEY = 2;

    private PrefetchTemplateUtil() {
    }

    public static String substituteTemplate(String theTemplate, CdsServiceRequestContextJson theContext, FhirContext theFhirContext) {
        String parsedDaVinciPrefetchTemplate = PrefetchTemplateUtil.handleDaVinciPrefetchTemplate(theTemplate, theContext, theFhirContext);
        return PrefetchTemplateUtil.handleDefaultPrefetchTemplate(parsedDaVinciPrefetchTemplate, theContext);
    }

    private static String handleDaVinciPrefetchTemplate(String theTemplate, CdsServiceRequestContextJson theContext, FhirContext theFhirContext) {
        Matcher matcher = daVinciPreFetch.matcher(theTemplate);
        String returnValue = theTemplate;
        while (matcher.find()) {
            String key = matcher.group(1);
            if (!theContext.containsKey(key)) {
                throw new InvalidRequestException(Msg.code((int)2372) + "Request context did not provide a value for key <" + key + ">.  Available keys in context are: " + theContext.getKeys());
            }
            try {
                IBaseBundle bundle = (IBaseBundle)theContext.getResource(key);
                String resourceType = matcher.group(2);
                String resourceIds = BundleUtil.toListOfResources((FhirContext)theFhirContext, (IBaseBundle)bundle).stream().filter(x -> x.fhirType().equals(resourceType)).map(x -> x.getIdElement().getIdPart()).collect(Collectors.joining(","));
                if (StringUtils.isEmpty((CharSequence)resourceIds)) {
                    throw new InvalidRequestException(Msg.code((int)2373) + "Request context did not provide for resource(s) matching template. ResourceType missing is: " + resourceType);
                }
                String keyToReplace = key + "." + resourceType + "\\.(id)";
                returnValue = PrefetchTemplateUtil.substitute(returnValue, keyToReplace, resourceIds);
            }
            catch (ClassCastException e) {
                throw new InvalidRequestException(Msg.code((int)2374) + "Request context did not provide valid " + theFhirContext.getVersion().getVersion() + " Bundle resource for template key <" + key + ">");
            }
        }
        return returnValue;
    }

    private static String handleDefaultPrefetchTemplate(String theTemplate, CdsServiceRequestContextJson theContext) {
        Matcher matcher = ourPlaceholder.matcher(theTemplate);
        String returnValue = theTemplate;
        while (matcher.find()) {
            String key = matcher.group(1);
            if (theContext.getString(key) == null) {
                throw new InvalidRequestException(Msg.code((int)2375) + "Either request context was empty or it did not provide a value for key <" + key + ">.  Please make sure you are including a context with valid keys.");
            }
            String value = theContext.getString(key);
            returnValue = PrefetchTemplateUtil.substitute(returnValue, key, value);
        }
        return returnValue;
    }

    private static String substitute(String theString, String theKey, String theValue) {
        return theString.replaceAll("\\{\\{context\\." + theKey + "}}", theValue);
    }
}

