/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.api;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.cr.common.IRepositoryFactory;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.rest.api.server.IRestfulResponse;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRestfulResponse;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.CdsCrSettings;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.opencds.cqf.fhir.utility.Ids;

public interface ICdsConfigService {
    @Nonnull
    public FhirContext getFhirContext();

    @Nonnull
    public ObjectMapper getObjectMapper();

    @Nonnull
    public CdsCrSettings getCdsCrSettings();

    @Nullable
    default public DaoRegistry getDaoRegistry() {
        return null;
    }

    @Nullable
    default public IRepositoryFactory getRepositoryFactory() {
        return null;
    }

    @Nullable
    default public RestfulServer getRestfulServer() {
        return null;
    }

    default public RequestDetails createRequestDetails(FhirContext theFhirContext, String theId, String theResourceType) {
        SystemRequestDetails rd = new SystemRequestDetails();
        rd.setServer(this.getRestfulServer());
        rd.setResponse((IRestfulResponse)new SystemRestfulResponse(rd));
        rd.setId(Ids.newId((FhirVersionEnum)theFhirContext.getVersion().getVersion(), (String)theResourceType, (String)theId));
        return rd;
    }
}

