/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.serializer;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestContextJson;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class CdsServiceRequestContextDeserializer
extends StdDeserializer<CdsServiceRequestContextJson> {
    private final IParser myParser;
    private final ObjectMapper myObjectMapper;

    public CdsServiceRequestContextDeserializer(FhirContext theFhirContext, ObjectMapper theObjectMapper) {
        super(CdsServiceRequestContextJson.class);
        this.myParser = theFhirContext.newJsonParser().setPrettyPrint(true);
        this.myObjectMapper = theObjectMapper;
    }

    public CdsServiceRequestContextJson deserialize(JsonParser theJsonParser, DeserializationContext theContext) throws IOException {
        LinkedHashMap map = (LinkedHashMap)this.myObjectMapper.readValue(theJsonParser.getCodec().readTree(theJsonParser).toString(), LinkedHashMap.class);
        CdsServiceRequestContextJson retval = new CdsServiceRequestContextJson();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof LinkedHashMap) {
                String json = this.myObjectMapper.writeValueAsString(value);
                IBaseResource resource = this.myParser.parseResource(json);
                retval.put(key, resource);
                continue;
            }
            retval.put(key, value);
        }
        return retval;
    }
}

