/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsMethod;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.ICdsCrServiceFactory;
import com.fasterxml.jackson.databind.ObjectMapper;

abstract class BaseCdsCrMethod
implements ICdsMethod {
    private ICdsCrServiceFactory myCdsCrServiceFactory;

    public BaseCdsCrMethod(ICdsCrServiceFactory theCdsCrServiceFactory) {
        this.myCdsCrServiceFactory = theCdsCrServiceFactory;
    }

    @Override
    public Object invoke(ObjectMapper theObjectMapper, IModelJson theJson, String theServiceId) {
        try {
            return this.myCdsCrServiceFactory.create(theServiceId).invoke(theJson);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof BaseServerResponseException) {
                throw (BaseServerResponseException)e.getCause();
            }
            throw new ConfigurationException(Msg.code((int)2434) + "Failed to invoke $apply on " + theServiceId, (Throwable)e);
        }
    }
}

