/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.hapi.fhir.cdshooks.api.CdsService;
import ca.uhn.hapi.fhir.cdshooks.api.CdsServiceFeedback;
import ca.uhn.hapi.fhir.cdshooks.api.CdsServicePrefetch;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsHooksExtension;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceJson;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsServiceCache;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PreDestroy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class CdsHooksContextBooter {
    protected static final Logger ourLog = LoggerFactory.getLogger(CdsHooksContextBooter.class);
    protected static final String CDS_SERVICES_BEAN_NAME = "cdsServices";
    protected Class<?> myDefinitionsClass;
    protected AnnotationConfigApplicationContext myAppCtx;
    protected List<Object> myCdsServiceBeans = new ArrayList<Object>();
    protected final CdsServiceCache myCdsServiceCache = new CdsServiceCache();

    public void setDefinitionsClass(Class<?> theDefinitionsClass) {
        this.myDefinitionsClass = theDefinitionsClass;
    }

    public CdsServiceCache buildCdsServiceCache() {
        for (Object serviceBean : this.myCdsServiceBeans) {
            this.extractCdsServices(serviceBean);
        }
        return this.myCdsServiceCache;
    }

    protected void extractCdsServices(Object theServiceBean) {
        Method[] methods = theServiceBean.getClass().getMethods();
        List sortedMethods = Arrays.stream(methods).sorted(Comparator.comparing(Method::getName)).collect(Collectors.toList());
        for (Method method : sortedMethods) {
            Annotation annotation;
            if (method.isAnnotationPresent(CdsService.class)) {
                annotation = method.getAnnotation(CdsService.class);
                CdsServiceJson cdsServiceJson = new CdsServiceJson();
                cdsServiceJson.setId(annotation.value());
                cdsServiceJson.setHook(annotation.hook());
                cdsServiceJson.setDescription(annotation.description());
                cdsServiceJson.setTitle(annotation.title());
                cdsServiceJson.setExtension(this.serializeExtensions(annotation.extension(), annotation.extensionClass()));
                cdsServiceJson.setExtensionClass(annotation.extensionClass());
                for (CdsServicePrefetch prefetch : annotation.prefetch()) {
                    cdsServiceJson.addPrefetch(prefetch.value(), prefetch.query());
                    cdsServiceJson.addSource(prefetch.value(), prefetch.source());
                }
                this.myCdsServiceCache.registerService(cdsServiceJson.getId(), theServiceBean, method, cdsServiceJson, annotation.allowAutoFhirClientPrefetch());
            }
            if (!method.isAnnotationPresent(CdsServiceFeedback.class)) continue;
            annotation = method.getAnnotation(CdsServiceFeedback.class);
            this.myCdsServiceCache.registerFeedback(annotation.value(), theServiceBean, method);
        }
    }

    CdsHooksExtension serializeExtensions(String theExtension, Class<? extends CdsHooksExtension> theClass) {
        if (StringUtils.isEmpty((CharSequence)theExtension)) {
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (CdsHooksExtension)mapper.readValue(theExtension, theClass);
        }
        catch (JsonProcessingException e) {
            String message = String.format("Invalid JSON: %s", e.getMessage());
            ourLog.debug(message);
            throw new UnprocessableEntityException(Msg.code((int)2378) + message);
        }
    }

    public void start() {
        if (this.myDefinitionsClass == null) {
            ourLog.info("No application context defined");
            return;
        }
        ourLog.info("Starting Spring ApplicationContext for class: {}", this.myDefinitionsClass);
        this.myAppCtx = new AnnotationConfigApplicationContext();
        this.myAppCtx.register(new Class[]{this.myDefinitionsClass});
        this.myAppCtx.refresh();
        try {
            if (this.myAppCtx.containsBean(CDS_SERVICES_BEAN_NAME)) {
                this.myCdsServiceBeans = (List)this.myAppCtx.getBean(CDS_SERVICES_BEAN_NAME, List.class);
            } else {
                ourLog.info("Context has no bean named {}", (Object)CDS_SERVICES_BEAN_NAME);
            }
            if (this.myCdsServiceBeans.isEmpty()) {
                throw new ConfigurationException(Msg.code((int)2379) + "No CDS Services found in the context (need bean called cdsServices)");
            }
        }
        catch (ConfigurationException e) {
            this.stop();
            throw e;
        }
        catch (Exception e) {
            this.stop();
            throw new ConfigurationException(Msg.code((int)2393) + e.getMessage(), (Throwable)e);
        }
    }

    @PreDestroy
    public void stop() {
        if (this.myAppCtx != null) {
            ourLog.info("Shutting down CDS Hooks Application context");
            this.myAppCtx.close();
            this.myAppCtx = null;
        }
    }
}

