/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc;

import ca.uhn.hapi.fhir.cdshooks.api.ICdsMethod;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsServiceMethod;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServicesJson;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsCrServiceMethod;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsDynamicPrefetchableServiceMethod;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsFeedbackMethod;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsServiceMethod;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.ICdsCrServiceFactory;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery.ICrDiscoveryServiceFactory;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsServiceCache {
    static final Logger ourLog = LoggerFactory.getLogger(CdsServiceCache.class);
    final Map<String, ICdsMethod> myServiceMap = new LinkedHashMap<String, ICdsMethod>();
    final Map<String, ICdsMethod> myFeedbackMap = new LinkedHashMap<String, ICdsMethod>();
    final CdsServicesJson myCdsServiceJson = new CdsServicesJson();

    public void registerService(String theServiceId, Object theServiceBean, Method theMethod, CdsServiceJson theCdsServiceJson, boolean theAllowAutoFhirClientPrefetch) {
        CdsServiceMethod cdsServiceMethod = new CdsServiceMethod(theCdsServiceJson, theServiceBean, theMethod, theAllowAutoFhirClientPrefetch);
        this.myServiceMap.put(theServiceId, cdsServiceMethod);
        this.myCdsServiceJson.addService(theCdsServiceJson);
    }

    public void registerDynamicService(String theServiceId, Function<CdsServiceRequestJson, CdsServiceResponseJson> theMethod, CdsServiceJson theCdsServiceJson, boolean theAllowAutoFhirClientPrefetch, String theModuleId) {
        if (!this.isCdsServiceAlreadyRegistered(theServiceId, theModuleId)) {
            CdsDynamicPrefetchableServiceMethod cdsDynamicPrefetchableServiceMethod = new CdsDynamicPrefetchableServiceMethod(theCdsServiceJson, theMethod, theAllowAutoFhirClientPrefetch);
            this.myServiceMap.put(theServiceId, cdsDynamicPrefetchableServiceMethod);
            this.myCdsServiceJson.addService(theCdsServiceJson);
        }
    }

    public void registerCrService(String theServiceId, ICrDiscoveryServiceFactory theDiscoveryServiceFactory, ICdsCrServiceFactory theCrServiceFactory) {
        CdsServiceJson cdsServiceJson;
        if (!this.isCdsServiceAlreadyRegistered(theServiceId, "CR") && (cdsServiceJson = theDiscoveryServiceFactory.create(theServiceId).resolveService()) != null) {
            CdsCrServiceMethod cdsCrServiceMethod = new CdsCrServiceMethod(cdsServiceJson, theCrServiceFactory);
            this.myServiceMap.put(theServiceId, cdsCrServiceMethod);
            this.myCdsServiceJson.addService(cdsServiceJson);
            ourLog.info("Created service for {}", (Object)theServiceId);
        }
    }

    public void registerFeedback(String theServiceId, Object theServiceBean, Method theMethod) {
        CdsFeedbackMethod cdsFeedbackMethod = new CdsFeedbackMethod(theServiceBean, theMethod);
        this.myFeedbackMap.put(theServiceId, cdsFeedbackMethod);
    }

    public ICdsMethod getServiceMethod(String theId) {
        return this.myServiceMap.get(theId);
    }

    public ICdsMethod getFeedbackMethod(String theId) {
        return this.myFeedbackMap.get(theId);
    }

    public CdsServicesJson getCdsServicesJson() {
        return this.myCdsServiceJson;
    }

    public ICdsMethod unregisterServiceMethod(String theServiceId, String theModuleId) {
        if (this.myServiceMap.containsKey(theServiceId)) {
            ICdsMethod serviceMethod = this.myServiceMap.get(theServiceId);
            this.myServiceMap.remove(theServiceId);
            if (serviceMethod instanceof ICdsServiceMethod) {
                this.myCdsServiceJson.removeService(((ICdsServiceMethod)serviceMethod).getCdsServiceJson());
            }
            return serviceMethod;
        }
        ourLog.error("CDS service with serviceId: {} for moduleId: {}, is not registered. Nothing to remove!", (Object)theServiceId, (Object)theModuleId);
        return null;
    }

    private boolean isCdsServiceAlreadyRegistered(String theServiceId, String theModuleId) {
        boolean result = this.myServiceMap.containsKey(theServiceId);
        if (result) {
            ourLog.error("CDS service with serviceId: {} for moduleId: {}, already exists. It will not be overwritten!", (Object)theServiceId, (Object)theModuleId);
        }
        return result;
    }

    CdsServiceJson getCdsServiceJson(String theString) {
        return this.myCdsServiceJson.getServices().stream().filter(x -> x.getId().equals(theString)).findFirst().orElse(null);
    }
}

