/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsMethod;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsServiceMethod;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsServiceRegistry;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsHooksExtension;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceFeedbackJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServicesJson;
import ca.uhn.hapi.fhir.cdshooks.serializer.CdsServiceRequestJsonDeserializer;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsHooksContextBooter;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsServiceCache;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.ICdsCrServiceFactory;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery.ICrDiscoveryServiceFactory;
import ca.uhn.hapi.fhir.cdshooks.svc.prefetch.CdsPrefetchSvc;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.function.Function;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsServiceRegistryImpl
implements ICdsServiceRegistry {
    private static final Logger ourLog = LoggerFactory.getLogger(CdsServiceRegistryImpl.class);
    private CdsServiceCache myServiceCache;
    private final CdsHooksContextBooter myCdsHooksContextBooter;
    private final CdsPrefetchSvc myCdsPrefetchSvc;
    private final ObjectMapper myObjectMapper;
    private final ICdsCrServiceFactory myCdsCrServiceFactory;
    private final ICrDiscoveryServiceFactory myCrDiscoveryServiceFactory;

    public CdsServiceRegistryImpl(CdsHooksContextBooter theCdsHooksContextBooter, CdsPrefetchSvc theCdsPrefetchSvc, ObjectMapper theObjectMapper, ICdsCrServiceFactory theCdsCrServiceFactory, ICrDiscoveryServiceFactory theCrDiscoveryServiceFactory, FhirContext theFhirContext) {
        this.myCdsHooksContextBooter = theCdsHooksContextBooter;
        this.myCdsPrefetchSvc = theCdsPrefetchSvc;
        this.myObjectMapper = theObjectMapper;
        SimpleModule module = new SimpleModule();
        module.addDeserializer(CdsServiceRequestJson.class, (JsonDeserializer)new CdsServiceRequestJsonDeserializer(this, theFhirContext));
        this.myObjectMapper.registerModule((Module)module);
        this.myCdsCrServiceFactory = theCdsCrServiceFactory;
        this.myCrDiscoveryServiceFactory = theCrDiscoveryServiceFactory;
    }

    @PostConstruct
    public void init() {
        this.myServiceCache = this.myCdsHooksContextBooter.buildCdsServiceCache();
    }

    @Override
    public CdsServicesJson getCdsServicesJson() {
        return this.myServiceCache.getCdsServicesJson();
    }

    @Override
    public CdsServiceResponseJson callService(String theServiceId, CdsServiceRequestJson theCdsServiceRequestJson) {
        ICdsServiceMethod serviceMethod = (ICdsServiceMethod)this.getCdsServiceMethodOrThrowException(theServiceId);
        this.myCdsPrefetchSvc.augmentRequest(theCdsServiceRequestJson, serviceMethod);
        Object response = serviceMethod.invoke(this.myObjectMapper, theCdsServiceRequestJson, theServiceId);
        return this.encodeServiceResponse(theServiceId, response);
    }

    @Override
    public CdsServiceFeedbackJson callFeedback(String theServiceId, CdsServiceFeedbackJson theCdsServiceFeedbackJson) {
        ICdsMethod feedbackMethod = this.getCdsFeedbackMethodOrThrowException(theServiceId);
        Object response = feedbackMethod.invoke(this.myObjectMapper, theCdsServiceFeedbackJson, theServiceId);
        return this.encodeFeedbackResponse(theServiceId, response);
    }

    @Override
    public void registerService(String theServiceId, Function<CdsServiceRequestJson, CdsServiceResponseJson> theServiceFunction, CdsServiceJson theCdsServiceJson, boolean theAllowAutoFhirClientPrefetch, String theModuleId) {
        if (theCdsServiceJson.getExtensionClass() == null) {
            theCdsServiceJson.setExtensionClass(CdsHooksExtension.class);
        }
        this.myServiceCache.registerDynamicService(theServiceId, theServiceFunction, theCdsServiceJson, theAllowAutoFhirClientPrefetch, theModuleId);
    }

    @Override
    public boolean registerCrService(String theServiceId) {
        try {
            this.myServiceCache.registerCrService(theServiceId, this.myCrDiscoveryServiceFactory, this.myCdsCrServiceFactory);
        }
        catch (Exception e) {
            ourLog.error("Error received during CR CDS Service registration: {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void unregisterService(String theServiceId, String theModuleId) {
        Validate.notNull((Object)theServiceId);
        ICdsMethod activeService = this.myServiceCache.unregisterServiceMethod(theServiceId, theModuleId);
        if (activeService != null) {
            ourLog.info("Unregistered active service {}", (Object)theServiceId);
        }
    }

    @Override
    public CdsServiceJson getCdsServiceJson(String theServiceId) {
        CdsServiceJson cdsServiceJson = this.myServiceCache.getCdsServiceJson(theServiceId);
        if (cdsServiceJson == null) {
            throw new IllegalArgumentException(Msg.code((int)2536) + "No service with " + theServiceId + " is registered.");
        }
        return cdsServiceJson;
    }

    @Nonnull
    private ICdsMethod getCdsServiceMethodOrThrowException(String theId) {
        ICdsMethod retval = this.myServiceCache.getServiceMethod(theId);
        if (retval == null) {
            throw new ResourceNotFoundException(Msg.code((int)2391) + "No service with id " + theId + " is registered on this server");
        }
        return retval;
    }

    @Nonnull
    CdsServiceResponseJson encodeServiceResponse(String theServiceId, Object result) {
        if (result instanceof String) {
            return this.buildResponseFromString(theServiceId, result, (String)result);
        }
        return this.buildResponseFromImplementation(theServiceId, result);
    }

    @Nonnull
    private ICdsMethod getCdsFeedbackMethodOrThrowException(String theId) {
        ICdsMethod retval = this.myServiceCache.getFeedbackMethod(theId);
        if (retval == null) {
            throw new ResourceNotFoundException(Msg.code((int)2392) + "No feedback service with id " + theId + " is registered on this server");
        }
        return retval;
    }

    @Nonnull
    CdsServiceFeedbackJson encodeFeedbackResponse(String theServiceId, Object theResponse) {
        if (theResponse instanceof String) {
            return this.buildFeedbackFromString(theServiceId, (String)theResponse);
        }
        return this.buildFeedbackFromImplementation(theServiceId, theResponse);
    }

    private CdsServiceResponseJson buildResponseFromImplementation(String theServiceId, Object theResult) {
        try {
            return (CdsServiceResponseJson)theResult;
        }
        catch (ClassCastException e) {
            throw new ConfigurationException(Msg.code((int)2389) + "Failed to cast Cds service response to CdsServiceResponseJson when calling CDS Hook Service " + theServiceId + ". The type " + theResult.getClass().getName() + " cannot be casted to CdsServiceResponseJson", (Throwable)e);
        }
    }

    private CdsServiceResponseJson buildResponseFromString(String theServiceId, Object theResult, String theJson) {
        try {
            return (CdsServiceResponseJson)this.myObjectMapper.readValue(theJson, CdsServiceResponseJson.class);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(Msg.code((int)2390) + "Failed to json deserialize Cds service response of type " + theResult.getClass().getName() + " when calling CDS Hook Service " + theServiceId + ".  Json: " + theJson, (Throwable)e);
        }
    }

    private CdsServiceFeedbackJson buildFeedbackFromImplementation(String theServiceId, Object theResponse) {
        try {
            return (CdsServiceFeedbackJson)theResponse;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(Msg.code((int)2537) + "Failed to cast feedback response CdsServiceFeedbackJson for service " + theServiceId + ". " + e.getMessage());
        }
    }

    private CdsServiceFeedbackJson buildFeedbackFromString(String theServiceId, String theResponse) {
        try {
            return (CdsServiceFeedbackJson)this.myObjectMapper.readValue(theResponse, CdsServiceFeedbackJson.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(Msg.code((int)2538) + "Failed to serialize json Cds Feedback response for service " + theServiceId + ". " + e.getMessage());
        }
    }

    @VisibleForTesting
    void setServiceCache(CdsServiceCache theCdsServiceCache) {
        this.myServiceCache = theCdsServiceCache;
    }
}

