/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.cr;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsConfigService;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestAuthorizationJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseCardJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseCardSourceJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseLinkJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseSuggestionActionJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseSuggestionJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseSystemActionJson;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.ICdsCrService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.ParameterDefinition;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.RequestGroup;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.dstu3.Parameters;

public class CdsCrServiceDstu3
implements ICdsCrService {
    protected final RequestDetails myRequestDetails;
    protected final Repository myRepository;
    protected final ICdsConfigService myCdsConfigService;
    protected CarePlan myResponse;
    protected CdsServiceResponseJson myServiceResponse;

    public CdsCrServiceDstu3(RequestDetails theRequestDetails, Repository theRepository, ICdsConfigService theCdsConfigService) {
        this.myCdsConfigService = theCdsConfigService;
        this.myRequestDetails = theRequestDetails;
        this.myRepository = theRepository;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return FhirVersionEnum.DSTU3;
    }

    @Override
    public Repository getRepository() {
        return this.myRepository;
    }

    public org.hl7.fhir.dstu3.model.Parameters encodeParams(CdsServiceRequestJson theJson) {
        Bundle data;
        org.hl7.fhir.dstu3.model.Parameters parameters = Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]).addParameter(Parameters.part((String)"subject", (String)theJson.getContext().getString("patientId"), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        if (theJson.getContext().containsKey("userId")) {
            parameters.addParameter(Parameters.part((String)"practitioner", (String)theJson.getContext().getString("userId"), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (theJson.getContext().containsKey("encounterId")) {
            parameters.addParameter(Parameters.part((String)"encounter", (String)theJson.getContext().getString("encounterId"), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        org.hl7.fhir.dstu3.model.Parameters cqlParameters = Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]);
        if (theJson.getContext().containsKey("draftOrders")) {
            this.addCqlParameters(cqlParameters, theJson.getContext().getResource("draftOrders"), "draftOrders");
        }
        if (cqlParameters.hasParameter()) {
            parameters.addParameter(Parameters.part((String)"parameters", (Resource)cqlParameters, (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if ((data = this.getPrefetchResources(theJson)).hasEntry()) {
            parameters.addParameter(Parameters.part((String)"data", (Resource)data, (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        return parameters;
    }

    protected String getTokenType(CdsServiceRequestAuthorizationJson theJson) {
        String tokenType = theJson.getTokenType();
        return tokenType == null || tokenType.isEmpty() ? "Bearer" : tokenType;
    }

    protected org.hl7.fhir.dstu3.model.Parameters addCqlParameters(org.hl7.fhir.dstu3.model.Parameters theParameters, IBaseResource theContextResource, String theParamName) {
        if (theContextResource instanceof Bundle) {
            ((Bundle)theContextResource).getEntry().forEach(x -> theParameters.addParameter(Parameters.part((String)theParamName, (Resource)x.getResource(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])));
        } else {
            theParameters.addParameter(Parameters.part((String)theParamName, (Resource)((Resource)theContextResource), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (theParameters.getParameter().size() == 1) {
            Extension listExtension = new Extension("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-parameterDefinition", (IBaseDatatype)new ParameterDefinition().setMax("*").setName(theParameters.getParameterFirstRep().getName()));
            theParameters.getParameterFirstRep().addExtension(listExtension);
        }
        return theParameters;
    }

    protected Map<String, Resource> getResourcesFromBundle(Bundle theBundle) {
        HashMap<String, Resource> resourceMap = new HashMap<String, Resource>();
        theBundle.getEntry().forEach(x -> resourceMap.put(x.fhirType() + x.getResource().getId(), x.getResource()));
        return resourceMap;
    }

    protected Bundle getPrefetchResources(CdsServiceRequestJson theJson) {
        HashMap<Object, Resource> resourceMap = new HashMap<Object, Resource>();
        Bundle prefetchResources = new Bundle();
        for (String key2 : theJson.getPrefetchKeys()) {
            Resource resource = (Resource)theJson.getPrefetch(key2);
            if (resource == null) continue;
            if (resource instanceof Bundle) {
                resourceMap.putAll(this.getResourcesFromBundle((Bundle)resource));
                continue;
            }
            resourceMap.put(resource.fhirType() + resource.getId(), resource);
        }
        resourceMap.forEach((key, value) -> prefetchResources.addEntry().setResource(value));
        return prefetchResources;
    }

    @Override
    public CdsServiceResponseJson encodeResponse(Object theResponse) {
        assert (theResponse instanceof CarePlan);
        this.myResponse = (CarePlan)theResponse;
        CdsServiceResponseJson serviceResponse = new CdsServiceResponseJson();
        if (this.myResponse.hasActivity()) {
            Reference requestGroupRef = ((CarePlan.CarePlanActivityComponent)this.myResponse.getActivity().get(0)).getReference();
            RequestGroup mainRequest = (RequestGroup)this.resolveResource(requestGroupRef);
            StringType canonical = ((Reference)mainRequest.getDefinition().get(0)).getReferenceElement_();
            PlanDefinition planDef = (PlanDefinition)this.myRepository.read(PlanDefinition.class, (IIdType)new IdType(Canonicals.getResourceType((IPrimitiveType)canonical), Canonicals.getIdPart((IPrimitiveType)canonical)));
            List<CdsServiceResponseLinkJson> links = this.resolvePlanLinks(planDef);
            mainRequest.getAction().forEach(action -> serviceResponse.addCard(this.resolveAction((RequestGroup.RequestGroupActionComponent)action, links)));
        }
        return serviceResponse;
    }

    protected List<CdsServiceResponseLinkJson> resolvePlanLinks(PlanDefinition thePlanDefinition) {
        ArrayList<CdsServiceResponseLinkJson> links = new ArrayList<CdsServiceResponseLinkJson>();
        if (thePlanDefinition.hasRelatedArtifact()) {
            thePlanDefinition.getRelatedArtifact().forEach(ra -> {
                String linkUrl = ra.getUrl();
                if (linkUrl != null) {
                    CdsServiceResponseLinkJson link = new CdsServiceResponseLinkJson().setUrl(linkUrl);
                    if (ra.hasDisplay()) {
                        link.setLabel(ra.getDisplay());
                    }
                    if (ra.hasExtension()) {
                        link.setType(ra.getExtensionFirstRep().getValue().primitiveValue());
                    } else {
                        link.setType("absolute");
                    }
                    links.add(link);
                }
            });
        }
        return links;
    }

    protected CdsServiceResponseCardJson resolveAction(RequestGroup.RequestGroupActionComponent theAction, List<CdsServiceResponseLinkJson> theLinks) {
        CdsServiceResponseCardJson card = new CdsServiceResponseCardJson().setSummary(theAction.getTitle()).setDetail(theAction.getDescription()).setLinks(theLinks);
        if (theAction.hasDocumentation()) {
            card.setSource(this.resolveSource(theAction));
        }
        if (theAction.hasSelectionBehavior()) {
            card.setSelectionBehaviour(theAction.getSelectionBehavior().toCode());
            theAction.getAction().forEach(action -> this.resolveSuggestion((RequestGroup.RequestGroupActionComponent)action));
        }
        return card;
    }

    protected void resolveSystemAction(RequestGroup.RequestGroupActionComponent theAction) {
        if (theAction.hasType() && theAction.getType().hasCode() && !theAction.getType().getCode().equals("fire-event")) {
            this.myServiceResponse.addServiceAction(new CdsServiceResponseSystemActionJson().setResource(this.resolveResource(theAction.getResource())).setType(theAction.getType().getCode()));
        }
    }

    protected CdsServiceResponseCardSourceJson resolveSource(RequestGroup.RequestGroupActionComponent theAction) {
        RelatedArtifact documentation = theAction.getDocumentationFirstRep();
        CdsServiceResponseCardSourceJson source = new CdsServiceResponseCardSourceJson().setLabel(documentation.getDisplay()).setUrl(documentation.getUrl());
        if (documentation.hasDocument() && documentation.getDocument().hasUrl()) {
            source.setIcon(documentation.getDocument().getUrl());
        }
        return source;
    }

    protected CdsServiceResponseSuggestionJson resolveSuggestion(RequestGroup.RequestGroupActionComponent theAction) {
        CdsServiceResponseSuggestionJson suggestion = new CdsServiceResponseSuggestionJson().setLabel(theAction.getTitle()).setUuid(theAction.getId());
        theAction.getAction().forEach(action -> suggestion.addAction(this.resolveSuggestionAction((RequestGroup.RequestGroupActionComponent)action)));
        return suggestion;
    }

    protected CdsServiceResponseSuggestionActionJson resolveSuggestionAction(RequestGroup.RequestGroupActionComponent theAction) {
        CdsServiceResponseSuggestionActionJson suggestionAction = new CdsServiceResponseSuggestionActionJson().setDescription(theAction.getDescription());
        if (theAction.hasType() && theAction.getType().hasCode() && !theAction.getType().getCode().equals("fire-event")) {
            String actionCode = theAction.getType().getCode();
            suggestionAction.setType(actionCode);
        }
        if (theAction.hasResource()) {
            suggestionAction.setResource(this.resolveResource(theAction.getResource()));
        }
        return suggestionAction;
    }

    protected IBaseResource resolveResource(Reference theReference) {
        return this.myResponse.getContained().stream().filter(resource -> resource.getId().equals(theReference.getReference())).findFirst().orElse(null);
    }
}

