/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.cr;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsConfigService;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceIndicatorEnum;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestAuthorizationJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseCardJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseCardSourceJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseLinkJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseSuggestionActionJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseSuggestionJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseSystemActionJson;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.ICdsCrService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.Canonicals;

public class CdsCrServiceR5
implements ICdsCrService {
    protected final RequestDetails myRequestDetails;
    protected final Repository myRepository;
    protected final ICdsConfigService myCdsConfigService;
    protected Bundle myResponseBundle;
    protected CdsServiceResponseJson myServiceResponse;

    public CdsCrServiceR5(RequestDetails theRequestDetails, Repository theRepository, ICdsConfigService theCdsConfigService) {
        this.myCdsConfigService = theCdsConfigService;
        this.myRequestDetails = theRequestDetails;
        this.myRepository = theRepository;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return FhirVersionEnum.R5;
    }

    @Override
    public Repository getRepository() {
        return this.myRepository;
    }

    public Parameters encodeParams(CdsServiceRequestJson theJson) {
        Bundle data;
        Parameters parameters = org.opencds.cqf.fhir.utility.r5.Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]).addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"subject", (String)theJson.getContext().getString("patientId"), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        if (theJson.getContext().containsKey("userId")) {
            parameters.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"practitioner", (String)theJson.getContext().getString("userId"), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (theJson.getContext().containsKey("encounterId")) {
            parameters.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"encounter", (String)theJson.getContext().getString("encounterId"), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        Parameters cqlParameters = org.opencds.cqf.fhir.utility.r5.Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]);
        if (theJson.getContext().containsKey("draftOrders")) {
            this.addCqlParameters(cqlParameters, theJson.getContext().getResource("draftOrders"), "draftOrders");
        }
        if (cqlParameters.hasParameter()) {
            parameters.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"parameters", (Resource)cqlParameters, (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if ((data = this.getPrefetchResources(theJson)).hasEntry()) {
            parameters.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"data", (Resource)data, (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        return parameters;
    }

    protected String getTokenType(CdsServiceRequestAuthorizationJson theJson) {
        String tokenType = theJson.getTokenType();
        return tokenType == null || tokenType.isEmpty() ? "Bearer" : tokenType;
    }

    protected Parameters addCqlParameters(Parameters theParameters, IBaseResource theContextResource, String theParamName) {
        if (theContextResource instanceof Bundle) {
            ((Bundle)theContextResource).getEntry().forEach(x -> theParameters.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)theParamName, (Resource)x.getResource(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])));
        } else {
            theParameters.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)theParamName, (Resource)((Resource)theContextResource), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (theParameters.getParameter().size() == 1) {
            Extension listExtension = new Extension("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-parameterDefinition", (IBaseDatatype)new ParameterDefinition().setMax("*").setName(theParameters.getParameterFirstRep().getName()));
            theParameters.getParameterFirstRep().addExtension(listExtension);
        }
        return theParameters;
    }

    protected Map<String, Resource> getResourcesFromBundle(Bundle theBundle) {
        HashMap<String, Resource> resourceMap = new HashMap<String, Resource>();
        theBundle.getEntry().forEach(x -> resourceMap.put(x.fhirType() + x.getResource().getId(), x.getResource()));
        return resourceMap;
    }

    protected Bundle getPrefetchResources(CdsServiceRequestJson theJson) {
        HashMap<Object, Resource> resourceMap = new HashMap<Object, Resource>();
        Bundle prefetchResources = new Bundle();
        for (String key2 : theJson.getPrefetchKeys()) {
            Resource resource = (Resource)theJson.getPrefetch(key2);
            if (resource == null) continue;
            if (resource instanceof Bundle) {
                resourceMap.putAll(this.getResourcesFromBundle((Bundle)resource));
                continue;
            }
            resourceMap.put(resource.fhirType() + resource.getId(), resource);
        }
        resourceMap.forEach((key, value) -> prefetchResources.addEntry().setResource(value));
        return prefetchResources;
    }

    @Override
    public CdsServiceResponseJson encodeResponse(Object theResponse) {
        assert (theResponse instanceof Bundle);
        this.myResponseBundle = (Bundle)theResponse;
        CdsServiceResponseJson serviceResponse = new CdsServiceResponseJson();
        if (this.myResponseBundle.hasEntry()) {
            RequestOrchestration mainRequest = (RequestOrchestration)((Bundle.BundleEntryComponent)this.myResponseBundle.getEntry().get(0)).getResource();
            CanonicalType canonical = (CanonicalType)mainRequest.getInstantiatesCanonical().get(0);
            PlanDefinition planDef = (PlanDefinition)this.myRepository.read(PlanDefinition.class, (IIdType)new IdType(Canonicals.getResourceType((IPrimitiveType)canonical), Canonicals.getIdPart((IPrimitiveType)canonical)));
            List<CdsServiceResponseLinkJson> links = this.resolvePlanLinks(planDef);
            mainRequest.getAction().forEach(action -> serviceResponse.addCard(this.resolveAction((RequestOrchestration.RequestOrchestrationActionComponent)action, links)));
        }
        return serviceResponse;
    }

    protected List<CdsServiceResponseLinkJson> resolvePlanLinks(PlanDefinition thePlanDefinition) {
        ArrayList<CdsServiceResponseLinkJson> links = new ArrayList<CdsServiceResponseLinkJson>();
        if (thePlanDefinition.hasRelatedArtifact()) {
            thePlanDefinition.getRelatedArtifact().forEach(ra -> {
                String linkUrl = ra.getDocument().getUrl();
                if (linkUrl != null) {
                    CdsServiceResponseLinkJson link = new CdsServiceResponseLinkJson().setUrl(linkUrl);
                    if (ra.hasDisplay()) {
                        link.setLabel(ra.getDisplay());
                    }
                    if (ra.hasExtension()) {
                        link.setType(ra.getExtensionFirstRep().getValue().primitiveValue());
                    } else {
                        link.setType("absolute");
                    }
                    links.add(link);
                }
            });
        }
        return links;
    }

    protected CdsServiceResponseCardJson resolveAction(RequestOrchestration.RequestOrchestrationActionComponent theAction, List<CdsServiceResponseLinkJson> theLinks) {
        CdsServiceResponseCardJson card = new CdsServiceResponseCardJson().setSummary(theAction.getTitle()).setDetail(theAction.getDescription()).setLinks(theLinks);
        if (theAction.hasPriority()) {
            card.setIndicator(this.resolveIndicator(theAction.getPriority().toCode()));
        }
        if (theAction.hasDocumentation()) {
            card.setSource(this.resolveSource(theAction));
        }
        if (theAction.hasSelectionBehavior()) {
            card.setSelectionBehaviour(theAction.getSelectionBehavior().toCode());
            theAction.getAction().forEach(action -> this.resolveSuggestion((RequestOrchestration.RequestOrchestrationActionComponent)action));
        }
        return card;
    }

    protected CdsServiceIndicatorEnum resolveIndicator(String theCode) {
        CdsServiceIndicatorEnum indicator;
        switch (theCode) {
            case "routine": {
                indicator = CdsServiceIndicatorEnum.INFO;
                break;
            }
            case "urgent": {
                indicator = CdsServiceIndicatorEnum.WARNING;
                break;
            }
            case "stat": {
                indicator = CdsServiceIndicatorEnum.CRITICAL;
                break;
            }
            default: {
                indicator = null;
            }
        }
        if (indicator == null) {
            throw new IllegalArgumentException(Msg.code((int)2436) + "Invalid priority code: " + theCode);
        }
        return indicator;
    }

    protected void resolveSystemAction(RequestOrchestration.RequestOrchestrationActionComponent theAction) {
        if (theAction.hasType() && theAction.getType().hasCoding() && theAction.getType().getCodingFirstRep().hasCode() && !theAction.getType().getCodingFirstRep().getCode().equals("fire-event")) {
            this.myServiceResponse.addServiceAction(new CdsServiceResponseSystemActionJson().setResource(this.resolveResource(theAction.getResource())).setType(theAction.getType().getCodingFirstRep().getCode()));
        }
    }

    protected CdsServiceResponseCardSourceJson resolveSource(RequestOrchestration.RequestOrchestrationActionComponent theAction) {
        RelatedArtifact documentation = theAction.getDocumentationFirstRep();
        CdsServiceResponseCardSourceJson source = new CdsServiceResponseCardSourceJson().setLabel(documentation.getDisplay()).setUrl(documentation.getDocument().getUrl());
        return source;
    }

    protected CdsServiceResponseSuggestionJson resolveSuggestion(RequestOrchestration.RequestOrchestrationActionComponent theAction) {
        CdsServiceResponseSuggestionJson suggestion = new CdsServiceResponseSuggestionJson().setLabel(theAction.getTitle()).setUuid(theAction.getId());
        theAction.getAction().forEach(action -> suggestion.addAction(this.resolveSuggestionAction((RequestOrchestration.RequestOrchestrationActionComponent)action)));
        return suggestion;
    }

    protected CdsServiceResponseSuggestionActionJson resolveSuggestionAction(RequestOrchestration.RequestOrchestrationActionComponent theAction) {
        CdsServiceResponseSuggestionActionJson suggestionAction = new CdsServiceResponseSuggestionActionJson().setDescription(theAction.getDescription());
        if (theAction.hasType() && theAction.getType().hasCoding() && theAction.getType().getCodingFirstRep().hasCode() && !theAction.getType().getCodingFirstRep().getCode().equals("fire-event")) {
            String actionCode = theAction.getType().getCodingFirstRep().getCode();
            suggestionAction.setType(actionCode);
        }
        if (theAction.hasResource()) {
            suggestionAction.setResource(this.resolveResource(theAction.getResource()));
        }
        return suggestionAction;
    }

    protected IBaseResource resolveResource(Reference theReference) {
        String reference = theReference.getReference();
        String[] split = reference.split("/");
        String id = reference.contains("/") ? split[1] : reference;
        String resourceType = reference.contains("/") ? split[0] : theReference.getType();
        List results = this.myResponseBundle.getEntry().stream().filter(entry -> entry.hasResource() && entry.getResource().getResourceType().toString().equals(resourceType) && entry.getResource().getIdPart().equals(id)).map(entry -> entry.getResource()).collect(Collectors.toList());
        return results.isEmpty() ? null : (IBaseResource)results.get(0);
    }
}

