/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.cr;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.api.Repository;

public class CdsCrUtils {
    public static IBaseResource readPlanDefinitionFromRepository(FhirVersionEnum theFhirVersion, Repository theRepository, IIdType theId) {
        switch (theFhirVersion) {
            case DSTU3: {
                return theRepository.read(PlanDefinition.class, theId);
            }
            case R4: {
                return theRepository.read(org.hl7.fhir.r4.model.PlanDefinition.class, theId);
            }
            case R5: {
                return theRepository.read(org.hl7.fhir.r5.model.PlanDefinition.class, theId);
            }
        }
        return null;
    }
}

